/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet.mvc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ResourceController
extends AbstractController {
    private static Log logger = LogFactory.getLog(ResourceController.class);
    private static final String HTTP_HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String HTTP_HEADER_LAST_MODIFIED = "Last-Modified";
    private static final String HTTP_HEADER_ETAG = "ETag";
    private static final String HTTP_HEADER_CACHE_CONTROL = "Cache-Control";
    private static final Map<String, String> defaultMimeTypes = new HashMap<String, String>();
    private String defaultUrl;
    private ThreadLocal<byte[]> streamBuffer;

    public ResourceController() {
        defaultMimeTypes.put(".css", "text/css");
        defaultMimeTypes.put(".gif", "image/gif");
        defaultMimeTypes.put(".ico", "image/vnd.microsoft.icon");
        defaultMimeTypes.put(".jpeg", "image/jpeg");
        defaultMimeTypes.put(".jpg", "image/jpeg");
        defaultMimeTypes.put(".js", "text/javascript");
        defaultMimeTypes.put(".png", "image/png");
        defaultMimeTypes.put(".bin", "application/octet-stream");
        this.streamBuffer = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[16384];
            }
        };
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        this.dispatchResource(path, request, response);
        return null;
    }

    public boolean dispatchResource(String path, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContextResource resource;
        boolean resolved;
        boolean debug;
        block14: {
            Resource r;
            block13: {
                debug = logger.isDebugEnabled();
                if (debug) {
                    logger.debug((Object)("Attemping to dispatch resource: " + path));
                }
                resolved = false;
                URL resourceUrl = ClassUtils.getDefaultClassLoader().getResource("META-INF/" + path);
                if (resourceUrl != null) {
                    if (debug) {
                        logger.debug((Object)("...dispatching resource from JAR location: " + resourceUrl));
                    }
                    try {
                        this.commitResponse(path, resourceUrl, response);
                        resolved = true;
                    }
                    catch (IOException ioe) {
                        logger.info((Object)ioe.getMessage());
                        if (!debug) break block13;
                        ioe.printStackTrace();
                    }
                }
            }
            if (!resolved && (r = this.getApplicationContext().getResource("classpath*:" + path)) != null && r.exists()) {
                URL resourceUrl = r.getURL();
                if (debug) {
                    logger.debug((Object)("...dispatching resource from classpath location: " + resourceUrl));
                }
                try {
                    this.commitResponse(path, resourceUrl, response);
                    resolved = true;
                }
                catch (IOException ioe) {
                    logger.info((Object)ioe.getMessage());
                    if (!debug) break block14;
                    ioe.printStackTrace();
                }
            }
        }
        if (!resolved && (resource = new ServletContextResource(this.getServletContext(), "/" + path)).exists()) {
            if (debug) {
                logger.debug((Object)"...dispatching resource from web application ServletContext.");
            }
            this.commitResponse(path, (Resource)resource, request, response);
            resolved = true;
        }
        if (!resolved && this.defaultUrl != null) {
            if (debug) {
                logger.debug((Object)("...handing off to Spring resource servlet: " + this.defaultUrl + "/" + path));
            }
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(this.defaultUrl + "/" + path);
            rd.forward((ServletRequest)request, (ServletResponse)response);
            resolved = true;
        }
        return resolved;
    }

    public void commitResponse(String path, URL resourceUrl, HttpServletResponse response) throws IOException {
        URLConnection resourceConn = resourceUrl.openConnection();
        this.applyHeaders(path, response, resourceConn.getContentLength(), resourceConn.getLastModified());
        this.copyStream(resourceUrl.openStream(), (OutputStream)response.getOutputStream());
    }

    public void commitResponse(String path, Resource resource, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        URLConnection resourceConn = resource.getURL().openConnection();
        this.applyHeaders(path, response, resourceConn.getContentLength(), resourceConn.getLastModified());
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/" + path);
        rd.include((ServletRequest)request, (ServletResponse)response);
    }

    protected void applyHeaders(String path, HttpServletResponse response, long contentLength, long lastModified) {
        String mimetype = this.getServletContext().getMimeType(path);
        if (mimetype == null) {
            String extension = ".bin";
            int extIndex = path.lastIndexOf(46);
            if (extIndex != -1) {
                extension = path.substring(extIndex);
                mimetype = defaultMimeTypes.get(extension.toLowerCase());
            }
        }
        response.setContentType(mimetype);
        response.setHeader(HTTP_HEADER_CONTENT_LENGTH, Long.toString(contentLength));
        if (lastModified != 0L) {
            response.setHeader(HTTP_HEADER_ETAG, '\"' + Long.toString(lastModified) + '\"');
            response.setDateHeader(HTTP_HEADER_LAST_MODIFIED, lastModified);
        }
        if (!response.containsHeader(HTTP_HEADER_CACHE_CONTROL)) {
            response.setHeader(HTTP_HEADER_CACHE_CONTROL, "max-age=86400");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            int byteCount;
            byte[] buffer = this.streamBuffer.get();
            while ((byteCount = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteCount);
            }
            out.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                in.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException ex) {}
    }
}

