/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.servlet.mvc;

import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.ServerConfigElement;
import org.springframework.extensions.config.ServerProperties;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.webscripts.RuntimeContainer;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.mvc.WebScriptViewRuntime;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.util.WebUtils;

public class WebScriptView
extends AbstractUrlBasedView {
    protected RuntimeContainer container;
    protected ServletAuthenticatorFactory authenticatorFactory;
    protected ConfigService configService;
    protected static ServerProperties serverProperties;

    public WebScriptView(RuntimeContainer container, ServletAuthenticatorFactory authenticatorFactory, ConfigService configService) {
        this.container = container;
        this.authenticatorFactory = authenticatorFactory;
        this.configService = configService;
        if (serverProperties == null) {
            Config config = configService.getConfig((Object)"Server");
            serverProperties = (ServerConfigElement)config.getConfigElement("server");
        }
    }

    protected void renderMergedOutputModel(Map model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String uri = this.getUrl();
        this.exposeModelAsRequestAttributes(model, request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processing request (" + request.getMethod() + ") " + request.getRequestURL() + (request.getQueryString() != null ? "?" + request.getQueryString() : "")));
        }
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("UTF-8");
        }
        if (I18NUtil.getLocaleOrNull() == null) {
            WebScriptView.setLanguageFromRequestHeader(request);
        }
        WebScriptViewRuntime runtime = new WebScriptViewRuntime(this.getUrl(), this.container, this.authenticatorFactory, request, response, serverProperties);
        runtime.executeScript();
    }

    protected void exposeForwardRequestAttributes(HttpServletRequest request) {
        WebUtils.exposeForwardRequestAttributes((HttpServletRequest)request);
    }

    public static void setLanguageFromRequestHeader(HttpServletRequest req) {
        String acceptLang = req.getHeader("Accept-Language");
        if (acceptLang != null && acceptLang.length() != 0) {
            StringTokenizer t = new StringTokenizer(acceptLang, ",; ");
            String language = t.nextToken().replace('-', '_');
            I18NUtil.setLocale((Locale)I18NUtil.parseLocale((String)language));
        }
    }
}

