/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.ui.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.NodeFactory;
import org.htmlparser.Parser;
import org.htmlparser.PrototypicalNodeFactory;
import org.htmlparser.Tag;
import org.htmlparser.Text;
import org.htmlparser.util.NodeIterator;
import org.htmlparser.util.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static final Log logger = LogFactory.getLog(StringUtils.class);
    private static final String ATTR_STYLE = "STYLE";
    private static final String ATTR_SRC = "SRC";
    private static final String ATTR_DYNSRC = "DYNSRC";
    private static final String ATTR_LOWSRC = "LOWSRC";
    private static final String ATTR_HREF = "HREF";
    private static final String ATTR_BACKGROUND = "BACKGROUND";
    private static final String ATTR_ON_PREFIX = "ON";
    private static final String ATTR_FORMACTION = "FORMACTION";
    private static final String ATTR_FORMMETHOD = "FORMMETHOD";
    private static final String ATTR_ACTION = "ACTION";
    protected static Set<String> attrBlackList = new HashSet<String>();
    protected static Set<String> attrGreyList;
    protected static Set<String> tagWhiteList;

    public void setTagWhiteList(Set<String> tags) {
        tagWhiteList = tags;
    }

    public void setAttributeGreyList(Set<String> attributes) {
        attrGreyList = attributes;
    }

    public void setAttributeBlackList(Set<String> attributes) {
        attrBlackList = attributes;
    }

    public static String encode(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String enc = null;
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    enc = "&quot;";
                    break;
                }
                case '&': {
                    enc = "&amp;";
                    break;
                }
                case '<': {
                    enc = "&lt;";
                    break;
                }
                case '>': {
                    enc = "&gt;";
                    break;
                }
                case '\u20ac': {
                    enc = "&euro;";
                    break;
                }
                case '\u00ab': {
                    enc = "&laquo;";
                    break;
                }
                case '\u00bb': {
                    enc = "&raquo;";
                    break;
                }
                case '\u00a0': {
                    enc = "&nbsp;";
                    break;
                }
                default: {
                    if (c < '\u0080') break;
                    enc = "&#" + c + ";";
                }
            }
            if (enc != null) {
                if (sb == null) {
                    String soFar = string.substring(0, i);
                    sb = new StringBuilder(i + 16);
                    sb.append(soFar);
                }
                sb.append(enc);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static String cropEncode(String text) {
        return StringUtils.cropEncode(text, 32);
    }

    public static String cropEncode(String text, int length) {
        if (text.length() > length) {
            String label = text.substring(0, length - 3) + "...";
            StringBuilder buf = new StringBuilder(length + 32 + text.length());
            buf.append("<span title=\"").append(StringUtils.encode(text)).append("\">").append(StringUtils.encode(label)).append("</span>");
            return buf.toString();
        }
        return StringUtils.encode(text);
    }

    public static String encodeJavascript(String s) {
        StringBuilder buf = new StringBuilder(s.length() * 3);
        for (int i = 0; i < s.length(); ++i) {
            char c;
            char iChar = c = s.charAt(i);
            buf.append('%');
            buf.append(Integer.toHexString(iChar));
        }
        return buf.toString();
    }

    public static String stripUnsafeHTMLTags(String s) {
        return StringUtils.stripUnsafeHTMLTags(s, true);
    }

    public static String stripUnsafeHTMLTags(String s, boolean encode) {
        String result = s;
        try {
            NodeIterator itr;
            PrototypicalNodeFactory factory;
            Parser parser;
            StringBuilder buf;
            int strippedLength;
            do {
                strippedLength = result.length();
                buf = new StringBuilder(result.length());
                parser = Parser.createParser((String)result, (String)"UTF-8");
                factory = new PrototypicalNodeFactory();
                parser.setNodeFactory((NodeFactory)factory);
                itr = parser.elements();
                StringUtils.processNodes(buf, itr, false);
            } while (strippedLength != (result = buf.toString()).length());
            if (encode) {
                buf = new StringBuilder(result.length());
                parser = Parser.createParser((String)result, (String)"UTF-8");
                factory = new PrototypicalNodeFactory();
                parser.setNodeFactory((NodeFactory)factory);
                itr = parser.elements();
                StringUtils.processNodes(buf, itr, true);
                result = buf.toString();
            }
        }
        catch (ParserException e) {
            return "";
        }
        return result;
    }

    private static void processNodes(StringBuilder buf, NodeIterator itr, boolean encode) throws ParserException {
        while (itr.hasMoreNodes()) {
            Node node = itr.nextNode();
            if (node instanceof Tag) {
                Tag tag = (Tag)node;
                String tagname = tag.getTagName();
                if (!tagWhiteList.contains(tagname)) continue;
                Vector attrs = tag.getAttributesEx();
                if (attrs.size() > 1) {
                    buf.append('<').append(tagname);
                    for (Attribute attr : attrs) {
                        String test;
                        String safeName;
                        String nameUpper;
                        String name = attr.getName();
                        if (name == null || tagname.equals(nameUpper = name.toUpperCase()) || (safeName = nameUpper.replaceAll("[^A-Z_]", "")).startsWith(ATTR_ON_PREFIX) || attrBlackList.contains(safeName)) continue;
                        String value = attr.getRawValue();
                        if (attrGreyList.contains(safeName) && attr.getValue() != null && (test = attr.getValue().trim()).length() > 2) {
                            if (test.startsWith("`")) {
                                test = test.substring(1);
                            }
                            if (test.startsWith("&#") || test.substring(0, 1).toUpperCase().charAt(0) == 'J' || test.substring(0, 2).toUpperCase().startsWith("VB")) {
                                value = "\"\"";
                            }
                        }
                        buf.append(' ').append(name);
                        if (value == null) continue;
                        buf.append('=').append(value);
                    }
                    buf.append('>');
                    if (tag.getChildren() == null) continue;
                    StringUtils.processNodes(buf, (NodeIterator)tag.getChildren().elements(), encode);
                    buf.append(tag.getEndTag().toHtml());
                    continue;
                }
                if (tag.getChildren() != null) {
                    buf.append('<').append(tagname).append('>');
                    StringUtils.processNodes(buf, (NodeIterator)tag.getChildren().elements(), encode);
                    buf.append(tag.getEndTag().toHtml());
                    continue;
                }
                buf.append(tag.toHtml());
                continue;
            }
            if (!(node instanceof Text)) continue;
            String txt = ((Text)node).toPlainTextString();
            buf.append(encode ? StringUtils.encode(txt) : txt);
        }
    }

    public static String replace(String str, String repl, String with) {
        if (str == null) {
            return null;
        }
        int lastindex = 0;
        int pos = str.indexOf(repl);
        if (pos < 0) {
            return str;
        }
        int len = repl.length();
        int lendiff = with.length() - repl.length();
        StringBuilder out = new StringBuilder(lendiff <= 0 ? str.length() : str.length() + (lendiff << 3));
        while (pos >= 0) {
            out.append(str.substring(lastindex, pos)).append(with);
            lastindex = pos + len;
            pos = str.indexOf(repl, lastindex);
        }
        return out.append(str.substring(lastindex, str.length())).toString();
    }

    public static String remove(String str, String match) {
        int lastindex = 0;
        int pos = str.indexOf(match);
        if (pos < 0) {
            return str;
        }
        int len = match.length();
        StringBuilder out = new StringBuilder(str.length());
        while (pos >= 0) {
            out.append(str.substring(lastindex, pos));
            lastindex = pos + len;
            pos = str.indexOf(match, lastindex);
        }
        return out.append(str.substring(lastindex, str.length())).toString();
    }

    public static String replaceLineBreaks(String str, boolean xhtml) {
        String replaced;
        block4: {
            replaced = null;
            if (str != null) {
                try {
                    StringBuilder parsedContent = new StringBuilder(str.length() + 32);
                    BufferedReader reader = new BufferedReader(new StringReader(str));
                    String line = reader.readLine();
                    while (line != null) {
                        parsedContent.append(line);
                        line = reader.readLine();
                        if (line == null) continue;
                        parsedContent.append(xhtml ? "<br/>" : "<br>");
                    }
                    replaced = parsedContent.toString();
                }
                catch (IOException ioe) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn((Object)("Failed to replace line breaks in string: " + str));
                }
            }
        }
        return replaced;
    }

    public static String join(Object[] value) {
        return StringUtils.join(value, null);
    }

    public static String join(Object[] value, String delim) {
        StringBuilder buf = new StringBuilder(value.length << 4);
        for (int i = 0; i < value.length; ++i) {
            if (i != 0 && delim != null) {
                buf.append(delim);
            }
            buf.append(value[i] != null ? value[i].toString() : "");
        }
        return buf.toString();
    }

    static {
        attrBlackList.add(ATTR_STYLE);
        attrGreyList = new HashSet<String>();
        attrGreyList.add(ATTR_SRC);
        attrGreyList.add(ATTR_DYNSRC);
        attrGreyList.add(ATTR_LOWSRC);
        attrGreyList.add(ATTR_HREF);
        attrGreyList.add(ATTR_BACKGROUND);
        attrGreyList.add(ATTR_FORMACTION);
        attrGreyList.add(ATTR_FORMMETHOD);
        attrGreyList.add(ATTR_ACTION);
        tagWhiteList = new HashSet<String>(64);
        tagWhiteList.add("!DOCTYPE");
        tagWhiteList.add("HTML");
        tagWhiteList.add("HEAD");
        tagWhiteList.add("BODY");
        tagWhiteList.add("META");
        tagWhiteList.add("BASE");
        tagWhiteList.add("TITLE");
        tagWhiteList.add("LINK");
        tagWhiteList.add("CENTER");
        tagWhiteList.add("EM");
        tagWhiteList.add("STRONG");
        tagWhiteList.add("SUP");
        tagWhiteList.add("SUB");
        tagWhiteList.add("P");
        tagWhiteList.add("B");
        tagWhiteList.add("I");
        tagWhiteList.add("U");
        tagWhiteList.add("BR");
        tagWhiteList.add("UL");
        tagWhiteList.add("OL");
        tagWhiteList.add("LI");
        tagWhiteList.add("H1");
        tagWhiteList.add("H2");
        tagWhiteList.add("H3");
        tagWhiteList.add("H4");
        tagWhiteList.add("H5");
        tagWhiteList.add("H6");
        tagWhiteList.add("SPAN");
        tagWhiteList.add("DIV");
        tagWhiteList.add("A");
        tagWhiteList.add("IMG");
        tagWhiteList.add("FONT");
        tagWhiteList.add("TABLE");
        tagWhiteList.add("THEAD");
        tagWhiteList.add("TBODY");
        tagWhiteList.add("TR");
        tagWhiteList.add("TH");
        tagWhiteList.add("TD");
        tagWhiteList.add("HR");
        tagWhiteList.add("DT");
        tagWhiteList.add("DL");
        tagWhiteList.add("DT");
        tagWhiteList.add("PRE");
        tagWhiteList.add("BLOCKQUOTE");
        tagWhiteList.add("BUTTON");
        tagWhiteList.add("CODE");
        tagWhiteList.add("FORM");
        tagWhiteList.add("OPTION");
        tagWhiteList.add("SELECT");
        tagWhiteList.add("TEXTAREA");
    }
}

