/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.webscripts.ui.common.tag;

import javax.faces.FacesException;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionEvent;
import javax.faces.webapp.UIComponentTag;
import org.springframework.extensions.webscripts.ui.common.ConstantMethodBinding;

public abstract class BaseComponentTag
extends UIComponentTag {
    protected static final Class[] ACTION_CLASS_ARGS = new Class[]{ActionEvent.class};

    protected void setActionProperty(UICommand command, String action) {
        if (action != null) {
            if (BaseComponentTag.isValueReference((String)action)) {
                MethodBinding vb = this.getFacesContext().getApplication().createMethodBinding(action, null);
                command.setAction(vb);
            } else {
                ConstantMethodBinding vb = new ConstantMethodBinding(action);
                command.setAction((MethodBinding)vb);
            }
        }
    }

    protected void setActionListenerProperty(UICommand command, String actionListener) {
        if (actionListener != null) {
            if (BaseComponentTag.isValueReference((String)actionListener)) {
                MethodBinding vb = this.getFacesContext().getApplication().createMethodBinding(actionListener, ACTION_CLASS_ARGS);
                command.setActionListener(vb);
            } else {
                throw new FacesException("Action listener method binding incorrectly specified: " + actionListener);
            }
        }
    }

    protected void setStringProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (BaseComponentTag.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(name, vb);
            } else {
                component.getAttributes().put(name, value);
            }
        }
    }

    protected void setStringBindingProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (BaseComponentTag.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(name, vb);
            } else {
                throw new IllegalArgumentException("Property: '" + name + "' must be a value binding expression.");
            }
        }
    }

    protected void setStringStaticProperty(UIComponent component, String name, String value) {
        if (value != null) {
            component.getAttributes().put(name, value);
        }
    }

    protected void setIntProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (BaseComponentTag.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(name, vb);
            } else {
                try {
                    component.getAttributes().put(name, Integer.valueOf(value));
                }
                catch (NumberFormatException ne) {
                    throw new RuntimeException("Was expecting Int value for property '" + name + "' but passed value: " + value);
                }
            }
        }
    }

    protected void setIntStaticProperty(UIComponent component, String name, String value) {
        if (value != null) {
            try {
                component.getAttributes().put(name, Integer.valueOf(value));
            }
            catch (NumberFormatException ne) {
                throw new RuntimeException("Was expecting Int value for property '" + name + "' but passed value: " + value);
            }
        }
    }

    protected void setBooleanProperty(UIComponent component, String name, String value) {
        if (value != null) {
            if (BaseComponentTag.isValueReference((String)value)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(value);
                component.setValueBinding(name, vb);
            } else {
                component.getAttributes().put(name, Boolean.valueOf(value));
            }
        }
    }

    protected void setBooleanStaticProperty(UIComponent component, String name, String value) {
        if (value != null) {
            component.getAttributes().put(name, Boolean.valueOf(value));
        }
    }
}

