/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.analytics.Step;
import com.google.gdata.util.ParseException;
import java.util.List;

@ExtensionDescription.Default(nsAlias="ga", nsUri="http://schemas.google.com/ga/2009", localName="destination")
public class Destination
extends ExtensionPoint {
    static final String XML_NAME = "destination";
    private static final String CASESENSITIVE = "caseSensitive";
    private static final String EXPRESSION = "expression";
    private static final String MATCHTYPE = "matchType";
    private static final String STEP1REQUIRED = "step1Required";
    private Boolean caseSensitive = null;
    private String expression = null;
    private String matchType = null;
    private Boolean step1Required = null;

    public Destination() {
    }

    public Destination(Boolean caseSensitive, String expression, String matchType, Boolean step1Required) {
        this.setCaseSensitive(caseSensitive);
        this.setExpression(expression);
        this.setMatchType(matchType);
        this.setStep1Required(step1Required);
        this.setImmutable(true);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(Destination.class)) {
            return;
        }
        extProfile.declare(Destination.class, Step.getDefaultDescription(false, true));
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.throwExceptionIfImmutable();
        this.caseSensitive = caseSensitive;
    }

    public boolean hasCaseSensitive() {
        return this.getCaseSensitive() != null;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.throwExceptionIfImmutable();
        this.expression = expression;
    }

    public boolean hasExpression() {
        return this.getExpression() != null;
    }

    public String getMatchType() {
        return this.matchType;
    }

    public void setMatchType(String matchType) {
        this.throwExceptionIfImmutable();
        this.matchType = matchType;
    }

    public boolean hasMatchType() {
        return this.getMatchType() != null;
    }

    public Boolean getStep1Required() {
        return this.step1Required;
    }

    public void setStep1Required(Boolean step1Required) {
        this.throwExceptionIfImmutable();
        this.step1Required = step1Required;
    }

    public boolean hasStep1Required() {
        return this.getStep1Required() != null;
    }

    public List<Step> getSteps() {
        return this.getRepeatingExtension(Step.class);
    }

    public void addStep(Step step) {
        this.getSteps().add(step);
    }

    public boolean hasSteps() {
        return this.hasRepeatingExtension(Step.class);
    }

    protected void validate() {
        if (this.caseSensitive == null) {
            Destination.throwExceptionForMissingAttribute((String)CASESENSITIVE);
        }
        if (this.expression == null) {
            Destination.throwExceptionForMissingAttribute((String)EXPRESSION);
        }
        if (this.matchType == null) {
            Destination.throwExceptionForMissingAttribute((String)MATCHTYPE);
        }
        if (this.step1Required == null) {
            Destination.throwExceptionForMissingAttribute((String)STEP1REQUIRED);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Destination.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(CASESENSITIVE, (Object)this.caseSensitive);
        generator.put((Object)EXPRESSION, (Object)this.expression);
        generator.put((Object)MATCHTYPE, (Object)this.matchType);
        generator.put(STEP1REQUIRED, (Object)this.step1Required);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.caseSensitive = helper.consumeBoolean(CASESENSITIVE, true);
        this.expression = helper.consume(EXPRESSION, true);
        this.matchType = helper.consume(MATCHTYPE, true);
        this.step1Required = helper.consumeBoolean(STEP1REQUIRED, true);
    }

    public String toString() {
        return "{Destination caseSensitive=" + this.caseSensitive + " expression=" + this.expression + " matchType=" + this.matchType + " step1Required=" + this.step1Required + "}";
    }

    public static final class MatchType {
        public static final String EXACT = "exact";
        public static final String HEAD = "head";
        public static final String REGEX = "regex";
    }
}

