/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.client.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.cmis.client.AlfrescoAspects;
import org.alfresco.cmis.client.impl.AlfrescoUtils;
import org.alfresco.cmis.client.impl.TransientAlfrescoAspectsImpl;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.TransientCmisObject;
import org.apache.chemistry.opencmis.client.runtime.TransientFolderImpl;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Updatability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientAlfrescoFolderImpl
extends TransientFolderImpl
implements AlfrescoAspects {
    protected TransientAlfrescoAspectsImpl aspects;

    protected void initialize(Session session, CmisObject object) {
        super.initialize(session, object);
        this.aspects = new TransientAlfrescoAspectsImpl(session, object);
    }

    @Override
    public ObjectType getTypeWithAspects() {
        return this.aspects.getTypeWithAspects();
    }

    public <T> void setPropertyValue(String id, Object value) {
        ObjectType aspectType = this.aspects.findAspect(id);
        if (aspectType == null) {
            super.setPropertyValue(id, value);
            return;
        }
        PropertyDefinition propertyDefinition = (PropertyDefinition)aspectType.getPropertyDefinitions().get(id);
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("Unknown property '" + id + "'!");
        }
        if (propertyDefinition.getUpdatability() == Updatability.READONLY) {
            throw new IllegalArgumentException("Property is read-only!");
        }
        List values = AlfrescoUtils.checkProperty(propertyDefinition, value);
        Property newProperty = this.getObjectFactory().createProperty(propertyDefinition, values);
        this.properties.put(id, newProperty);
        this.isPropertyUpdateRequired = true;
        this.isModified = true;
    }

    @Override
    public boolean hasAspect(String id) {
        return this.aspects.hasAspect(id);
    }

    @Override
    public boolean hasAspect(ObjectType type) {
        return this.aspects.hasAspect(type);
    }

    @Override
    public Collection<ObjectType> getAspects() {
        return this.aspects.getAspects();
    }

    @Override
    public ObjectType findAspect(String propertyId) {
        return this.aspects.findAspect(propertyId);
    }

    @Override
    public void addAspect(String ... id) {
        this.aspects.addAspect(id);
    }

    @Override
    public void addAspect(ObjectType ... type) {
        this.aspects.addAspect(type);
    }

    @Override
    public void removeAspect(String ... id) {
        this.aspects.removeAspect(id);
    }

    @Override
    public void addAspect(ObjectType type, Map<String, ?> properties) {
        this.aspects.addAspect(type);
        this.aspects.setPropertyValues((TransientCmisObject)this, properties);
    }

    @Override
    public void addAspect(ObjectType[] type, Map<String, ?> properties) {
        this.aspects.addAspect(type);
        this.aspects.setPropertyValues((TransientCmisObject)this, properties);
    }

    @Override
    public void addAspect(String id, Map<String, ?> properties) {
        this.aspects.addAspect(id);
        this.aspects.setPropertyValues((TransientCmisObject)this, properties);
    }

    @Override
    public void addAspect(String[] id, Map<String, ?> properties) {
        this.aspects.addAspect(id);
        this.aspects.setPropertyValues((TransientCmisObject)this, properties);
    }

    @Override
    public void removeAspect(ObjectType ... type) {
        this.aspects.removeAspect(type);
    }

    public ObjectId save() {
        ObjectId id = super.save();
        if (!this.isMarkedForDelete) {
            this.aspects.save();
        }
        return id;
    }

    protected Properties prepareProperties() {
        ObjectType type = this.getType();
        PropertyDefinition propDef = (PropertyDefinition)type.getPropertyDefinitions().get("cmis:objectTypeId");
        String objectTypeIdValue = AlfrescoUtils.createObjectTypeIdValue(type, this.getAspects());
        Property objectTypeIdProperty = this.getObjectFactory().createProperty(propDef, Collections.singletonList(objectTypeIdValue));
        this.properties.put("cmis:objectTypeId", objectTypeIdProperty);
        return super.prepareProperties();
    }
}

