/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.impl.server.TypeCacheImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomPubUtils;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserBindingUtils;
import org.apache.chemistry.opencmis.server.impl.browser.ControlParser;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;

public class VersioningService {
    private VersioningService() {
    }

    public static void checkOut(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String transaction = HttpUtils.getStringParameter(request, "cmistransaction");
        Holder checkOutId = new Holder((Object)objectId);
        service.checkOut(repositoryId, checkOutId, null, null);
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, (String)checkOutId.getValue());
        if (object == null) {
            throw new CmisRuntimeException("PWC is null!");
        }
        TypeCacheImpl typeCache = new TypeCacheImpl(repositoryId, service);
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false);
        String location = AtomPubUtils.compileUrl(AtomPubUtils.compileBaseUrl(request, repositoryId), "content", object.getId());
        BrowserBindingUtils.setStatus(request, response, 201);
        response.setHeader("Location", location);
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void cancelCheckOut(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        service.cancelCheckOut(repositoryId, objectId, null);
        response.setStatus(200);
        BrowserBindingUtils.writeEmpty(request, response);
    }

    public static void checkIn(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        String typeId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectTypeId");
        Boolean major = HttpUtils.getBooleanParameter(request, "major");
        String checkinComment = HttpUtils.getStringParameter(request, "checkinComment");
        String transaction = HttpUtils.getStringParameter(request, "cmistransaction");
        ControlParser cp = new ControlParser(request);
        TypeCacheImpl typeCache = new TypeCacheImpl(repositoryId, service);
        Holder objectIdHolder = new Holder((Object)objectId);
        service.checkIn(repositoryId, objectIdHolder, major, BrowserBindingUtils.createProperties(cp, typeId, (TypeCache)typeCache), BrowserBindingUtils.createContentStream(request), checkinComment, BrowserBindingUtils.createPolicies(cp), BrowserBindingUtils.createAddAcl(cp), BrowserBindingUtils.createRemoveAcl(cp), null);
        String newObjectId = objectIdHolder.getValue() == null ? objectId : (String)objectIdHolder.getValue();
        ObjectData object = BrowserBindingUtils.getSimpleObject(service, repositoryId, newObjectId);
        if (object == null) {
            throw new CmisRuntimeException("New version is null!");
        }
        JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (boolean)false);
        String location = AtomPubUtils.compileUrl(AtomPubUtils.compileBaseUrl(request, repositoryId), "content", object.getId());
        BrowserBindingUtils.setStatus(request, response, 201);
        response.setHeader("Location", location);
        BrowserBindingUtils.setCookie(request, response, repositoryId, transaction, BrowserBindingUtils.createCookieValue(201, object.getId(), null, null));
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonObject, request, response);
    }

    public static void getAllVersions(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean includeAllowableActions;
        String filter;
        String objectId = (String)context.get("org.apache.chemistry.opencmis.browserbinding.objectId");
        List versions = service.getAllVersions(repositoryId, objectId, null, filter = HttpUtils.getStringParameter(request, "filter"), includeAllowableActions = HttpUtils.getBooleanParameter(request, "includeAllowableActions"), null);
        if (versions == null) {
            throw new CmisRuntimeException("Versions are null!");
        }
        TypeCacheImpl typeCache = new TypeCacheImpl(repositoryId, service);
        JSONArray jsonVersions = new JSONArray();
        for (ObjectData version : versions) {
            jsonVersions.add((Object)JSONConverter.convert((ObjectData)version, (TypeCache)typeCache, (boolean)false));
        }
        response.setStatus(200);
        BrowserBindingUtils.writeJSON((JSONStreamAware)jsonVersions, request, response);
    }
}

