/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.api;

import org.json.JSONException;
import org.json.JSONStringer;
import org.json.JSONWriter;

public class PhotoTag {
    private double _x;
    private double _y;
    private Integer _taggedUserId;
    private String _text;

    public PhotoTag(String text, double x, double y) {
        assert (text != null && !"".equals(text));
        this._text = text;
        this._taggedUserId = null;
        this.setCoordinates(x, y);
    }

    public PhotoTag(int taggedUserId, double x, double y) {
        assert (taggedUserId > 0);
        this._text = null;
        this._taggedUserId = taggedUserId;
        this.setCoordinates(x, y);
    }

    private void setCoordinates(double x, double y) {
        assert (0.0 <= x && x <= 0.0);
        assert (0.0 <= y && y <= 100.0);
        this._x = x;
        this._y = y;
    }

    public boolean hasTaggedUser() {
        return this._taggedUserId != null;
    }

    public double getX() {
        return this._x;
    }

    public double getY() {
        return this._y;
    }

    public String getText() {
        return this._text;
    }

    public Integer getTaggedUserId() {
        return this._taggedUserId;
    }

    public JSONWriter jsonify(JSONWriter writer) throws JSONException {
        JSONWriter ret = (writer == null ? new JSONStringer() : writer).object().key("x").value((Object)Double.toString(this.getX())).key("y").value((Object)Double.toString(this.getY()));
        return this.hasTaggedUser() ? ret.key("tag_uid").value((Object)this.getTaggedUserId()).endObject() : ret.key("tag_text").value((Object)this.getText()).endObject();
    }
}

