/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.imap.ImapRequestHandler;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionImpl;
import com.icegreen.greenmail.user.UserManager;
import com.icegreen.greenmail.util.InternetPrintWriter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;

public class ImapHandler
extends Thread
implements ImapConstants {
    private ImapRequestHandler requestHandler = new ImapRequestHandler();
    private ImapSession session;
    private Socket socket;
    private BufferedReader in;
    private InputStream ins;
    private InternetPrintWriter out;
    private OutputStream outs;
    UserManager userManager;
    private ImapHostManager imapHost;

    public ImapHandler(UserManager userManager, ImapHostManager imapHost, Socket socket) {
        this.userManager = userManager;
        this.imapHost = imapHost;
        this.socket = socket;
    }

    public void forceConnectionClose(String message) {
        ImapResponse response = new ImapResponse(this.outs);
        response.byeResponse(message);
        this.resetHandler();
    }

    @Override
    public void run() {
        String remoteHost = "";
        String remoteIP = "";
        try {
            this.ins = this.socket.getInputStream();
            this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "ISO-8859-1"), 4096);
            remoteIP = this.socket.getInetAddress().getHostAddress();
            remoteHost = this.socket.getInetAddress().getHostName();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            try {
                this.outs = new BufferedOutputStream(this.socket.getOutputStream(), 1024);
                this.out = new InternetPrintWriter(this.outs, true);
                ImapResponse response = new ImapResponse(this.outs);
                StringBuffer responseBuffer = new StringBuffer(256).append("IMAP4rev1").append(" Server ").append("GreenMail").append(" ready");
                response.okResponse(null, responseBuffer.toString());
                this.session = new ImapSessionImpl(this.imapHost, this.userManager, this, this.socket.getInetAddress().getHostName(), this.socket.getInetAddress().getHostAddress());
                while (this.requestHandler.handleRequest(this.ins, this.outs, this.session)) {
                }
            }
            catch (Exception exception) {
                this.resetHandler();
            }
        }
        finally {
            this.resetHandler();
        }
    }

    void resetHandler() {
        block29: {
            block27: {
                block25: {
                    block23: {
                        try {
                            try {
                                try {
                                    if (this.socket != null && !this.socket.isClosed()) {
                                        this.socket.close();
                                    }
                                }
                                catch (NullPointerException nullPointerException) {}
                            }
                            catch (IOException iOException) {
                                this.socket = null;
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            this.socket = null;
                            throw throwable;
                        }
                        this.socket = null;
                    }
                    try {
                        try {
                            if (this.in != null) {
                                this.in.close();
                            }
                        }
                        catch (Exception exception) {
                            this.in = null;
                            break block25;
                        }
                    }
                    catch (Throwable throwable) {
                        this.in = null;
                        throw throwable;
                    }
                    this.in = null;
                }
                try {
                    try {
                        if (this.out != null) {
                            this.out.close();
                        }
                    }
                    catch (Exception exception) {
                        this.out = null;
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    this.out = null;
                    throw throwable;
                }
                this.out = null;
            }
            try {
                try {
                    if (this.outs != null) {
                        this.outs.close();
                    }
                }
                catch (Exception exception) {
                    this.outs = null;
                    break block29;
                }
            }
            catch (Throwable throwable) {
                this.outs = null;
                throw throwable;
            }
            this.outs = null;
        }
        this.session = null;
    }

    private void stat() {
    }

    final void writeLoggedFlushedResponse(String responseString) {
        this.out.println(responseString);
        this.out.flush();
    }

    final void writeLoggedResponse(String responseString) {
        this.out.println(responseString);
    }
}

