/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.SimpleStoredMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.Flags;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;

public class ImapSessionFolder
implements MailFolder,
FolderListener {
    private MailFolder _folder;
    private ImapSession _session;
    private boolean _readonly;
    private boolean _sizeChanged;
    private List _expungedMsns = Collections.synchronizedList(new LinkedList());
    private Map _modifiedFlags = Collections.synchronizedMap(new TreeMap());

    public ImapSessionFolder(MailFolder folder, ImapSession session, boolean readonly) {
        this._folder = folder;
        this._session = session;
        this._readonly = readonly;
        this._folder.addListener(this);
    }

    public void deselect() {
        this._folder.removeListener(this);
        this._folder = null;
    }

    @Override
    public int getMsn(long uid) throws FolderException {
        return this._folder.getMsn(uid);
    }

    @Override
    public void signalDeletion() {
        this._folder.signalDeletion();
    }

    @Override
    public List getMessages(MsgRangeFilter msgRangeFilter) {
        return this._folder.getMessages(msgRangeFilter);
    }

    @Override
    public List getMessages() {
        return this._folder.getMessages();
    }

    @Override
    public List getNonDeletedMessages() {
        return this._folder.getNonDeletedMessages();
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getExpunged() throws FolderException {
        List list = this._expungedMsns;
        synchronized (list) {
            int[] expungedMsns = new int[this._expungedMsns.size()];
            int i = 0;
            while (i < expungedMsns.length) {
                int msn;
                expungedMsns[i] = msn = ((Integer)this._expungedMsns.get(i)).intValue();
                ++i;
            }
            this._expungedMsns.clear();
            if (!this._modifiedFlags.isEmpty() || this._sizeChanged) {
                throw new IllegalStateException("Need to do this properly...");
            }
            return expungedMsns;
        }
    }

    public List getFlagUpdates() throws FolderException {
        if (this._modifiedFlags.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList retVal = new ArrayList();
        retVal.addAll(this._modifiedFlags.values());
        this._modifiedFlags.clear();
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expunged(int msn) {
        List list = this._expungedMsns;
        synchronized (list) {
            this._expungedMsns.add(new Integer(msn));
        }
    }

    @Override
    public void added(int msn) {
        this._sizeChanged = true;
    }

    @Override
    public void flagsUpdated(int msn, Flags flags, Long uid) {
        this._modifiedFlags.put(new Integer(msn), new FlagUpdate(msn, uid, flags));
    }

    @Override
    public void mailboxDeleted() {
        this._session.closeConnection("Mailbox " + this._folder.getName() + " has been deleted");
    }

    @Override
    public String getName() {
        return this._folder.getName();
    }

    @Override
    public String getFullName() {
        return this._folder.getFullName();
    }

    @Override
    public Flags getPermanentFlags() {
        return this._folder.getPermanentFlags();
    }

    @Override
    public int getMessageCount() {
        return this._folder.getMessageCount();
    }

    @Override
    public int getRecentCount(boolean reset) {
        return this._folder.getRecentCount(reset);
    }

    @Override
    public long getUidValidity() {
        return this._folder.getUidValidity();
    }

    @Override
    public int getFirstUnseen() {
        return this.correctForExpungedMessages(this._folder.getFirstUnseen());
    }

    private int correctForExpungedMessages(int absoluteMsn) {
        int correctedMsn = absoluteMsn;
        int i = this._expungedMsns.size() - 1;
        while (i >= 0) {
            Integer expunged = (Integer)this._expungedMsns.get(i);
            if (expunged <= absoluteMsn) {
                ++correctedMsn;
            }
            --i;
        }
        return correctedMsn;
    }

    @Override
    public boolean isSelectable() {
        return this._folder.isSelectable();
    }

    @Override
    public boolean isMarked() {
        return this._folder.isMarked();
    }

    @Override
    public long getUidNext() {
        return this._folder.getUidNext();
    }

    @Override
    public int getUnseenCount() {
        return this._folder.getUnseenCount();
    }

    @Override
    public long appendMessage(MimeMessage message, Flags flags, Date internalDate) throws FolderException {
        return this._folder.appendMessage(message, flags, internalDate);
    }

    @Override
    public void store(MovingMessage mail) throws Exception {
        this._folder.store(mail);
    }

    @Override
    public void store(MimeMessage mail) throws Exception {
        this._folder.store(mail);
    }

    @Override
    public SimpleStoredMessage getMessage(long uid) {
        return this._folder.getMessage(uid);
    }

    @Override
    public long[] getMessageUids() {
        return this._folder.getMessageUids();
    }

    @Override
    public void expunge() throws FolderException {
        this._folder.expunge();
    }

    @Override
    public long[] search(SearchTerm searchTerm) {
        return this._folder.search(searchTerm);
    }

    @Override
    public void copyMessage(long uid, MailFolder toFolder) throws FolderException {
        this._folder.copyMessage(uid, toFolder);
    }

    @Override
    public void addListener(FolderListener listener) {
        this._folder.addListener(listener);
    }

    @Override
    public void removeListener(FolderListener listener) {
        this._folder.removeListener(listener);
    }

    public IdRange[] msnsToUids(IdRange[] idSet) {
        return new IdRange[0];
    }

    @Override
    public void setFlags(Flags flags, boolean value, long uid, FolderListener silentListener, boolean addUid) throws FolderException {
        this._folder.setFlags(flags, value, uid, silentListener, addUid);
    }

    @Override
    public void replaceFlags(Flags flags, long uid, FolderListener silentListener, boolean addUid) throws FolderException {
        this._folder.replaceFlags(flags, uid, silentListener, addUid);
    }

    @Override
    public void deleteAllMessages() throws FolderException {
        this._folder.deleteAllMessages();
    }

    public boolean isSizeChanged() {
        return this._sizeChanged;
    }

    public void setSizeChanged(boolean sizeChanged) {
        this._sizeChanged = sizeChanged;
    }

    static final class FlagUpdate {
        private int msn;
        private Long uid;
        private Flags flags;

        public FlagUpdate(int msn, Long uid, Flags flags) {
            this.msn = msn;
            this.uid = uid;
            this.flags = flags;
        }

        public int getMsn() {
            return this.msn;
        }

        public Long getUid() {
            return this.uid;
        }

        public Flags getFlags() {
            return this.flags;
        }
    }
}

