/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapConstants;
import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionState;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.CommandParser;
import com.icegreen.greenmail.imap.commands.ImapCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;

abstract class CommandTemplate
implements ImapCommand,
ImapConstants {
    protected CommandParser parser = new CommandParser();

    CommandTemplate() {
    }

    @Override
    public boolean validForState(ImapSessionState state) {
        return true;
    }

    @Override
    public void process(ImapRequestLineReader request, ImapResponse response, ImapSession session) {
        try {
            this.doProcess(request, response, session);
        }
        catch (FolderException e) {
            response.commandFailed(this, e.getResponseCode(), e.getMessage());
        }
        catch (AuthorizationException e) {
            String msg = "Authorization error: Lacking permissions to perform requested operation.";
            response.commandFailed(this, msg);
        }
        catch (ProtocolException e) {
            String msg = String.valueOf(e.getMessage()) + " Command should be '" + this.getExpectedMessage() + "'";
            response.commandError(msg);
        }
    }

    protected abstract void doProcess(ImapRequestLineReader var1, ImapResponse var2, ImapSession var3) throws ProtocolException, FolderException, AuthorizationException;

    protected String getExpectedMessage() {
        StringBuffer syntax = new StringBuffer("<tag> ");
        syntax.append(this.getName());
        String args = this.getArgSyntax();
        if (args != null && args.length() > 0) {
            syntax.append(" ");
            syntax.append(args);
        }
        return syntax.toString();
    }

    protected abstract String getArgSyntax();

    protected MailFolder getMailbox(String mailboxName, ImapSession session, boolean mustExist) throws FolderException {
        return session.getHost().getFolder(session.getUser(), mailboxName, mustExist);
    }

    protected MailFolder getMailbox(String mailboxName, ImapSession session) {
        try {
            return session.getHost().getFolder(session.getUser(), mailboxName, false);
        }
        catch (FolderException e) {
            throw new RuntimeException("Unexpected error in CommandTemplate.java");
        }
    }

    public CommandParser getParser() {
        return this.parser;
    }
}

