/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.store;

import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailMessageAttributes;
import com.icegreen.greenmail.store.SimpleMessageAttributes;
import com.icegreen.greenmail.store.StoredMessage;
import java.util.Date;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class SimpleStoredMessage
implements StoredMessage {
    private MimeMessage mimeMessage;
    private Flags flags;
    private Date internalDate;
    private long uid;
    private SimpleMessageAttributes attributes;

    public SimpleStoredMessage(MimeMessage mimeMessage, Date internalDate, long uid) throws MessagingException {
        this(mimeMessage, mimeMessage.getFlags(), internalDate, uid);
    }

    SimpleStoredMessage(MimeMessage mimeMessage, Flags flags, Date internalDate, long uid) {
        this.mimeMessage = mimeMessage;
        this.flags = flags;
        this.internalDate = internalDate;
        this.uid = uid;
    }

    @Override
    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    @Override
    public Flags getFlags() {
        return this.flags;
    }

    @Override
    public Date getInternalDate() {
        return this.internalDate;
    }

    @Override
    public long getUid() {
        return this.uid;
    }

    @Override
    public MailMessageAttributes getAttributes() throws FolderException {
        if (this.attributes == null) {
            this.attributes = new SimpleMessageAttributes();
            try {
                this.attributes.setAttributesFor(this.mimeMessage);
            }
            catch (MessagingException e) {
                throw new FolderException("Could not parse mime message." + e.getMessage());
            }
        }
        return this.attributes;
    }
}

