/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.user;

import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.user.GreenMailUser;
import com.icegreen.greenmail.user.UserException;
import java.io.Serializable;
import javax.mail.internet.MimeMessage;

public class UserImpl
implements GreenMailUser,
Serializable {
    String email;
    String login;
    String password;
    private ImapHostManager imapHostManager;

    public UserImpl(String email, String login, String password, ImapHostManager imapHostManager) {
        this.email = email;
        this.login = login;
        this.password = password;
        this.imapHostManager = imapHostManager;
    }

    @Override
    public void create() throws UserException {
        try {
            this.imapHostManager.createPrivateMailAccount(this);
        }
        catch (Exception me) {
            throw new UserException(me);
        }
    }

    @Override
    public void delete() throws UserException {
    }

    @Override
    public void deliver(MovingMessage msg) throws UserException {
        try {
            this.imapHostManager.getInbox(this).store(msg);
        }
        catch (Exception me) {
            throw new UserException(me);
        }
    }

    @Override
    public void deliver(MimeMessage msg) throws UserException {
        try {
            this.imapHostManager.getInbox(this).store(msg);
        }
        catch (Exception me) {
            throw new UserException(me);
        }
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getLogin() {
        if (this.login == null) {
            return this.email;
        }
        return this.login;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void authenticate(String pass) throws UserException {
        if (!this.password.equals(pass)) {
            throw new UserException("Invalid password");
        }
    }

    @Override
    public String getQualifiedMailboxName() {
        return String.valueOf(this.email.hashCode());
    }

    public int hashCode() {
        return this.email.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserImpl) || o == null) {
            return false;
        }
        UserImpl that = (UserImpl)o;
        return this.email.equals(that.email);
    }
}

