/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.linkedin.api.impl;

import java.util.List;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.social.linkedin.api.LinkedIn;
import org.springframework.social.linkedin.api.LinkedInConnections;
import org.springframework.social.linkedin.api.LinkedInProfile;
import org.springframework.social.linkedin.api.impl.LinkedInModule;
import org.springframework.social.oauth1.AbstractOAuth1ApiBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedInTemplate
extends AbstractOAuth1ApiBinding
implements LinkedIn {
    static final String PROFILE_URL = "https://api.linkedin.com/v1/people/~:(id,first-name,last-name,headline,industry,site-standard-profile-request,public-profile-url,picture-url)?format=json";

    public LinkedInTemplate(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret) {
        super(consumerKey, consumerSecret, accessToken, accessTokenSecret);
        this.registerLinkedInJsonModule();
    }

    @Override
    public String getProfileId() {
        return this.getUserProfile().getId();
    }

    @Override
    public String getProfileUrl() {
        return this.getUserProfile().getPublicProfileUrl();
    }

    @Override
    public LinkedInProfile getUserProfile() {
        return (LinkedInProfile)this.getRestTemplate().getForObject(PROFILE_URL, LinkedInProfile.class, new Object[0]);
    }

    @Override
    public List<LinkedInProfile> getConnections() {
        LinkedInConnections connections = (LinkedInConnections)this.getRestTemplate().getForObject("https://api.linkedin.com/v1/people/~/connections?format=json", LinkedInConnections.class, new Object[0]);
        return connections.getConnections();
    }

    private void registerLinkedInJsonModule() {
        List converters = this.getRestTemplate().getMessageConverters();
        for (HttpMessageConverter converter : converters) {
            if (!(converter instanceof MappingJacksonHttpMessageConverter)) continue;
            MappingJacksonHttpMessageConverter jsonConverter = (MappingJacksonHttpMessageConverter)converter;
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new LinkedInModule());
            jsonConverter.setObjectMapper(objectMapper);
        }
    }
}

