/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.AbstractMP3FragmentBody;
import org.farng.mp3.InvalidTagException;

public abstract class AbstractID3v2FrameBody
extends AbstractMP3FragmentBody {
    protected AbstractID3v2FrameBody() {
    }

    protected AbstractID3v2FrameBody(AbstractID3v2FrameBody copyObject) {
        super(copyObject);
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractID3v2FrameBody && super.equals(obj);
    }

    protected int readHeader(RandomAccessFile file) throws IOException, InvalidTagException {
        int size;
        byte[] buffer = new byte[3];
        if (AbstractID3v2FrameBody.has6ByteHeader()) {
            file.read(buffer, 0, 3);
            size = (int)((double)buffer[0] * Math.pow(2.0, 16.0) + (double)buffer[1] * Math.pow(2.0, 8.0) + (double)buffer[2]);
        } else {
            size = file.readInt();
            file.skipBytes(2);
        }
        if (size == 0) {
            throw new InvalidTagException("Found empty frame");
        }
        if (size <= 0 || (long)size > file.length()) {
            throw new InvalidTagException("Invalid size for Frame Body");
        }
        return size;
    }

    protected void writeHeader(RandomAccessFile file, int size) throws IOException {
        byte[] buffer = new byte[3];
        if (AbstractID3v2FrameBody.has6ByteHeader()) {
            buffer[0] = (byte)((size & 0xFF0000) >> 16);
            buffer[1] = (byte)((size & 0xFF00) >> 8);
            buffer[2] = (byte)(size & 0xFF);
            file.write(buffer);
        } else {
            file.writeInt(size);
            file.skipBytes(2);
        }
    }
}

