/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.farng.mp3.InvalidTagException;
import org.farng.mp3.id3.AbstractID3v2FrameBody;

public class FrameBodyASPI
extends AbstractID3v2FrameBody {
    private short[] fraction = null;
    private int bitsPerPoint = 0;
    private int dataLength = 0;
    private int dataStart = 0;
    private int indexPoints = 0;

    public FrameBodyASPI() {
    }

    public FrameBodyASPI(FrameBodyASPI copyObject) {
        super(copyObject);
        this.fraction = (short[])copyObject.fraction.clone();
        this.bitsPerPoint = copyObject.bitsPerPoint;
        this.dataLength = copyObject.dataLength;
        this.dataStart = copyObject.dataStart;
        this.indexPoints = copyObject.indexPoints;
    }

    public FrameBodyASPI(int dataStart, int dataLength, int indexPoints, int bitsPerPoint, short[] fraction) {
        this.dataStart = dataStart;
        this.dataLength = dataLength;
        this.indexPoints = indexPoints;
        this.bitsPerPoint = bitsPerPoint;
        this.fraction = new short[fraction.length];
        System.arraycopy(fraction, 0, this.fraction, 0, fraction.length);
    }

    public FrameBodyASPI(RandomAccessFile file) throws IOException, InvalidTagException {
        this.read(file);
    }

    public String getIdentifier() {
        return "ASPI";
    }

    public int getSize() {
        return 11 + this.fraction.length << 1;
    }

    public void equals() {
        throw new UnsupportedOperationException("Method equals() not yet implemented.");
    }

    protected void setupObjectList() {
    }

    public void read(RandomAccessFile file) throws IOException, InvalidTagException {
        int size = this.readHeader(file);
        if (size == 0) {
            throw new InvalidTagException("Empty Frame");
        }
        this.dataStart = file.readInt();
        this.dataLength = file.readInt();
        this.indexPoints = file.readShort();
        this.bitsPerPoint = file.readByte();
        this.fraction = new short[this.indexPoints];
        for (int i = 0; i < this.indexPoints; ++i) {
            if (this.bitsPerPoint == 8) {
                this.fraction[i] = file.readByte();
                continue;
            }
            if (this.bitsPerPoint == 16) {
                this.fraction[i] = file.readShort();
                continue;
            }
            throw new InvalidTagException("ASPI bits per point wasn't 8 or 16");
        }
    }

    public String toString() {
        return this.getIdentifier() + ' ' + this.dataStart + ' ' + this.dataLength + ' ' + this.indexPoints + ' ' + this.bitsPerPoint + ' ' + this.fraction.toString();
    }

    public void write(RandomAccessFile file) throws IOException {
        this.writeHeader(file, this.getSize());
        file.writeInt(this.dataStart);
        file.writeInt(this.dataLength);
        file.writeShort(this.indexPoints);
        file.writeByte(16);
        for (int i = 0; i < this.indexPoints; ++i) {
            file.writeShort(this.fraction[i]);
        }
    }
}

