/*
 * Decompiled with CFR 0.152.
 */
package org.farng.mp3.object;

import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.farng.mp3.TagConstant;
import org.farng.mp3.object.ObjectHashMapInterface;
import org.farng.mp3.object.ObjectNumberFixedLength;

public class ObjectNumberHashMap
extends ObjectNumberFixedLength
implements ObjectHashMapInterface {
    public static final String GENRE = "Genre";
    public static final String TEXT_ENCODING = "Text Encoding";
    public static final String INTERPOLATION_METHOD = "Interpolation Method";
    public static final String ID3V2_FRAME_DESCRIPTION = "ID3v2 Frame Description";
    public static final String PICTURE_TYPE = "Picture Type";
    public static final String TYPE_OF_EVENT = "Type Of Event";
    public static final String TIME_STAMP_FORMAT = "Time Stamp Format";
    public static final String TYPE_OF_CHANNEL = "Type Of Channel";
    public static final String RECIEVED_AS = "Recieved As";
    private HashMap idToString = null;
    private HashMap stringToId = null;
    private boolean hasEmptyValue = false;

    public ObjectNumberHashMap(String identifier, int size) {
        super(identifier, size);
        if (identifier.equals(GENRE)) {
            this.stringToId = TagConstant.genreStringToId;
            this.idToString = TagConstant.genreIdToString;
            this.hasEmptyValue = true;
        } else if (identifier.equals(TEXT_ENCODING)) {
            this.stringToId = TagConstant.textEncodingStringToId;
            this.idToString = TagConstant.textEncodingIdToString;
        } else if (identifier.equals(INTERPOLATION_METHOD)) {
            this.stringToId = TagConstant.interpolationMethodStringToId;
            this.idToString = TagConstant.interpolationMethodIdToString;
        } else if (identifier.equals(ID3V2_FRAME_DESCRIPTION)) {
            this.stringToId = TagConstant.id3v2_4FrameStringToId;
            this.idToString = TagConstant.id3v2_4FrameIdToString;
        } else if (identifier.equals(PICTURE_TYPE)) {
            this.stringToId = TagConstant.pictureTypeStringToId;
            this.idToString = TagConstant.pictureTypeIdToString;
        } else if (identifier.equals(TYPE_OF_EVENT)) {
            this.stringToId = TagConstant.typeOfEventStringToId;
            this.idToString = TagConstant.typeOfEventIdToString;
        } else if (identifier.equals(TIME_STAMP_FORMAT)) {
            this.stringToId = TagConstant.timeStampFormatStringToId;
            this.idToString = TagConstant.timeStampFormatIdToString;
        } else if (identifier.equals(TYPE_OF_CHANNEL)) {
            this.stringToId = TagConstant.typeOfChannelStringToId;
            this.idToString = TagConstant.typeOfChannelIdToString;
        } else if (identifier.equals(RECIEVED_AS)) {
            this.stringToId = TagConstant.recievedAsStringToId;
            this.idToString = TagConstant.recievedAsIdToString;
        } else {
            throw new IllegalArgumentException("Hashmap identifier not defined in this class: " + identifier);
        }
    }

    public ObjectNumberHashMap(ObjectNumberHashMap copyObject) {
        super(copyObject);
        this.hasEmptyValue = copyObject.hasEmptyValue;
        this.idToString = copyObject.idToString;
        this.stringToId = copyObject.stringToId;
    }

    public HashMap getIdToString() {
        return this.idToString;
    }

    public HashMap getStringToId() {
        return this.stringToId;
    }

    public void setValue(Object value) {
        this.value = value instanceof Byte ? new Long(((Byte)value).byteValue()) : (value instanceof Short ? new Long(((Short)value).shortValue()) : (value instanceof Integer ? new Long(((Integer)value).intValue()) : value));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectNumberHashMap)) {
            return false;
        }
        ObjectNumberHashMap objectNumberHashMap = (ObjectNumberHashMap)obj;
        if (this.hasEmptyValue != objectNumberHashMap.hasEmptyValue) {
            return false;
        }
        if (this.idToString == null ? objectNumberHashMap.idToString != null : !this.idToString.equals(objectNumberHashMap.idToString)) {
            return false;
        }
        if (this.stringToId == null ? objectNumberHashMap.stringToId != null : !this.stringToId.equals(objectNumberHashMap.stringToId)) {
            return false;
        }
        return super.equals(obj);
    }

    public Iterator iterator() {
        if (this.idToString == null) {
            return null;
        }
        TreeSet treeSet = new TreeSet(this.idToString.values());
        if (this.hasEmptyValue) {
            treeSet.add("");
        }
        return treeSet.iterator();
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        if (this.idToString.get(this.value) == null) {
            return "";
        }
        return this.idToString.get(this.value).toString();
    }
}

