/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.converter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.basic.AbstractBasicConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import net.sf.jooreports.converter.BasicDocumentFormatRegistry;
import net.sf.jooreports.converter.DocumentFamily;
import net.sf.jooreports.converter.DocumentFormat;
import net.sf.jooreports.converter.DocumentFormatRegistry;
import org.apache.commons.io.IOUtils;

public class XmlDocumentFormatRegistry
extends BasicDocumentFormatRegistry
implements DocumentFormatRegistry {
    private static final String DEFAULT_CONFIGURATION = "/" + XmlDocumentFormatRegistry.class.getPackage().getName().replace('.', '/') + "/document-formats.xml";

    public XmlDocumentFormatRegistry() {
        this.load(this.getClass().getResourceAsStream(DEFAULT_CONFIGURATION));
    }

    public XmlDocumentFormatRegistry(InputStream inputStream) {
        this.load(inputStream);
    }

    private void load(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        XStream xstream = this.createXStream();
        try {
            try {
                ObjectInputStream in = xstream.createObjectInputStream((Reader)new InputStreamReader(inputStream));
                try {
                    while (true) {
                        this.addDocumentFormat((DocumentFormat)in.readObject());
                    }
                }
                catch (EOFException eOFException) {
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("invalid registry configuration", exception);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private XStream createXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.setMode(1001);
        xstream.alias("document-format", DocumentFormat.class);
        xstream.aliasField("mime-type", DocumentFormat.class, "mimeType");
        xstream.aliasField("file-extension", DocumentFormat.class, "fileExtension");
        xstream.aliasField("export-filters", DocumentFormat.class, "exportFilters");
        xstream.aliasField("export-options", DocumentFormat.class, "exportOptions");
        xstream.alias("family", DocumentFamily.class);
        xstream.registerConverter((Converter)new AbstractBasicConverter(){

            public boolean canConvert(Class type) {
                return type.equals(DocumentFamily.class);
            }

            protected Object fromString(String name) {
                return DocumentFamily.getFamily(name);
            }
        });
        return xstream;
    }
}

