/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.openoffice.connection;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.net.ConnectException;
import net.sf.jooreports.openoffice.connection.OpenOfficeConnection;
import net.sf.jooreports.openoffice.connection.OpenOfficeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractOpenOfficeConnection
implements OpenOfficeConnection,
XEventListener {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String connectionString;
    private XComponent bridgeComponent;
    private XMultiComponentFactory serviceManager;
    private XComponentContext componentContext;
    private boolean connected = false;
    private boolean expectingDisconnection = false;

    protected AbstractOpenOfficeConnection(String connectionString) {
        this.connectionString = connectionString;
    }

    @Override
    public synchronized void connect() throws ConnectException {
        this.logger.debug((Object)"connecting");
        try {
            XComponentContext localContext = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory localServiceManager = localContext.getServiceManager();
            XConnector connector = (XConnector)UnoRuntime.queryInterface(XConnector.class, (Object)localServiceManager.createInstanceWithContext("com.sun.star.connection.Connector", localContext));
            XConnection connection = connector.connect(this.connectionString);
            XBridgeFactory bridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)localServiceManager.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", localContext));
            XBridge bridge = bridgeFactory.createBridge("", "urp", connection, null);
            this.bridgeComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)bridge);
            this.bridgeComponent.addEventListener((XEventListener)this);
            this.serviceManager = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)bridge.getInstance("StarOffice.ServiceManager"));
            XPropertySet properties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.serviceManager);
            this.componentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)properties.getPropertyValue("DefaultContext"));
            this.connected = true;
            this.logger.info((Object)"connected");
        }
        catch (NoConnectException connectException) {
            throw new ConnectException("connection failed: " + this.connectionString + ": " + connectException.getMessage());
        }
        catch (Exception exception) {
            throw new OpenOfficeException("connection failed: " + this.connectionString, exception);
        }
    }

    @Override
    public synchronized void disconnect() {
        this.logger.debug((Object)"disconnecting");
        this.expectingDisconnection = true;
        this.bridgeComponent.dispose();
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void disposing(EventObject event) {
        this.connected = false;
        if (this.expectingDisconnection) {
            this.logger.info((Object)"disconnected");
        } else {
            this.logger.error((Object)"disconnected unexpectedly");
        }
        this.expectingDisconnection = false;
    }

    void simulateUnexpectedDisconnection() {
        this.disposing(null);
        this.bridgeComponent.dispose();
    }

    private Object getService(String className) {
        try {
            if (!this.connected) {
                this.logger.info((Object)"trying to (re)connect");
                this.connect();
            }
            return this.serviceManager.createInstanceWithContext(className, this.componentContext);
        }
        catch (Exception exception) {
            throw new OpenOfficeException("could not obtain service: " + className, exception);
        }
    }

    @Override
    public XComponentLoader getDesktop() {
        return (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.getService("com.sun.star.frame.Desktop"));
    }

    @Override
    public XFileIdentifierConverter getFileContentProvider() {
        return (XFileIdentifierConverter)UnoRuntime.queryInterface(XFileIdentifierConverter.class, (Object)this.getService("com.sun.star.ucb.FileContentProvider"));
    }
}

