/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.openoffice.converter;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jooreports.converter.DocumentFormat;
import net.sf.jooreports.converter.DocumentFormatRegistry;
import net.sf.jooreports.openoffice.connection.OpenOfficeConnection;
import net.sf.jooreports.openoffice.connection.OpenOfficeException;
import net.sf.jooreports.openoffice.converter.AbstractOpenOfficeDocumentConverter;
import org.apache.commons.io.IOUtils;

public class OpenOfficeDocumentConverter
extends AbstractOpenOfficeDocumentConverter {
    public OpenOfficeDocumentConverter(OpenOfficeConnection connection) {
        super(connection);
    }

    public OpenOfficeDocumentConverter(OpenOfficeConnection connection, DocumentFormatRegistry formatRegistry) {
        super(connection, formatRegistry);
    }

    @Override
    protected void convertInternal(InputStream inputStream, DocumentFormat inputFormat, OutputStream outputStream, DocumentFormat outputFormat) {
        File inputFile = null;
        File outputFile = null;
        try {
            try {
                inputFile = File.createTempFile("document", "." + inputFormat.getFileExtension());
                FileOutputStream inputFileStream = null;
                try {
                    inputFileStream = new FileOutputStream(inputFile);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)inputFileStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputFileStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)inputFileStream);
                outputFile = File.createTempFile("document", "." + outputFormat.getFileExtension());
                this.convert(inputFile, inputFormat, outputFile, outputFormat);
                FileInputStream outputFileStream = null;
                try {
                    outputFileStream = new FileInputStream(outputFile);
                    IOUtils.copy((InputStream)outputFileStream, (OutputStream)outputStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputFileStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)outputFileStream);
            }
            catch (IOException ioException) {
                throw new OpenOfficeException("conversion failed", ioException);
            }
        }
        finally {
            if (inputFile != null) {
                inputFile.delete();
            }
            if (outputFile != null) {
                outputFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void convertInternal(File inputFile, DocumentFormat inputFormat, File outputFile, DocumentFormat outputFormat) {
        OpenOfficeConnection openOfficeConnection = this.openOfficeConnection;
        synchronized (openOfficeConnection) {
            XFileIdentifierConverter fileContentProvider = this.openOfficeConnection.getFileContentProvider();
            String inputUrl = fileContentProvider.getFileURLFromSystemPath("", inputFile.getAbsolutePath());
            String outputUrl = fileContentProvider.getFileURLFromSystemPath("", outputFile.getAbsolutePath());
            PropertyValue[] exportProperties = new PropertyValue[]{OpenOfficeDocumentConverter.property("FilterName", outputFormat.getExportFilter(inputFormat.getFamily())), OpenOfficeDocumentConverter.property("FilterData", OpenOfficeDocumentConverter.toPropertyValues(outputFormat.getExportOptions()))};
            try {
                this.loadAndExport(inputUrl, outputUrl, exportProperties);
            }
            catch (Throwable throwable) {
                throw new OpenOfficeException("conversion failed", throwable);
            }
        }
    }

    private void loadAndExport(String inputUrl, String outputUrl, PropertyValue[] exportProperties) throws Exception {
        PropertyValue[] propertyValueArray;
        XComponentLoader desktop = this.openOfficeConnection.getDesktop();
        if (this.isTextUtf8()) {
            PropertyValue[] propertyValueArray2 = new PropertyValue[5];
            propertyValueArray2[0] = OpenOfficeDocumentConverter.property("ReadOnly", Boolean.TRUE);
            propertyValueArray2[1] = OpenOfficeDocumentConverter.property("FilterOptions", "utf8");
            propertyValueArray2[2] = OpenOfficeDocumentConverter.property("FilterName", "Text (encoded)");
            propertyValueArray2[3] = OpenOfficeDocumentConverter.property("UpdateDocModel", ONE);
            propertyValueArray = propertyValueArray2;
            propertyValueArray2[4] = OpenOfficeDocumentConverter.property("Hidden", Boolean.TRUE);
        } else {
            PropertyValue[] propertyValueArray3 = new PropertyValue[2];
            propertyValueArray3[0] = OpenOfficeDocumentConverter.property("ReadOnly", Boolean.TRUE);
            propertyValueArray = propertyValueArray3;
            propertyValueArray3[1] = OpenOfficeDocumentConverter.property("Hidden", Boolean.TRUE);
        }
        PropertyValue[] propertyValues = propertyValueArray;
        XComponent document = desktop.loadComponentFromURL(inputUrl, "_blank", 0, propertyValues);
        this.refreshDocument(document);
        try {
            XStorable storable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)document);
            storable.storeToURL(outputUrl, exportProperties);
        }
        finally {
            document.dispose();
        }
    }
}

