/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jooreports.openoffice.converter;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.XComponent;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.lib.uno.adapter.OutputStreamToXOutputStreamAdapter;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jooreports.converter.DocumentFormat;
import net.sf.jooreports.converter.DocumentFormatRegistry;
import net.sf.jooreports.openoffice.connection.OpenOfficeConnection;
import net.sf.jooreports.openoffice.connection.OpenOfficeException;
import net.sf.jooreports.openoffice.converter.AbstractOpenOfficeDocumentConverter;
import org.apache.commons.io.IOUtils;

public class StreamOpenOfficeDocumentConverter
extends AbstractOpenOfficeDocumentConverter {
    public StreamOpenOfficeDocumentConverter(OpenOfficeConnection connection) {
        super(connection);
    }

    public StreamOpenOfficeDocumentConverter(OpenOfficeConnection connection, DocumentFormatRegistry formatRegistry) {
        super(connection, formatRegistry);
    }

    @Override
    protected void convertInternal(File inputFile, DocumentFormat inputFormat, File outputFile, DocumentFormat outputFormat) {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            try {
                inputStream = new FileInputStream(inputFile);
                outputStream = new FileOutputStream(outputFile);
                this.convert(inputStream, inputFormat, outputStream, outputFormat);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(fileNotFoundException.getMessage());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void convertInternal(InputStream inputStream, DocumentFormat inputFormat, OutputStream outputStream, DocumentFormat outputFormat) {
        String filterName = outputFormat.getExportFilter(inputFormat.getFamily());
        try {
            OpenOfficeConnection openOfficeConnection = this.openOfficeConnection;
            synchronized (openOfficeConnection) {
                this.loadAndExport(inputStream, outputStream, filterName, StreamOpenOfficeDocumentConverter.toPropertyValues(outputFormat.getExportOptions()));
            }
        }
        catch (Throwable throwable) {
            throw new OpenOfficeException("conversion failed", throwable);
        }
    }

    private void loadAndExport(InputStream inputStream, OutputStream outputStream, String filterName, PropertyValue[] filterData) throws Exception {
        XComponentLoader desktop = this.openOfficeConnection.getDesktop();
        XComponent document = desktop.loadComponentFromURL("private:stream", "_blank", 0, new PropertyValue[]{StreamOpenOfficeDocumentConverter.property("ReadOnly", Boolean.TRUE), StreamOpenOfficeDocumentConverter.property("Hidden", Boolean.TRUE), StreamOpenOfficeDocumentConverter.property("InputStream", new ByteArrayToXInputStreamAdapter(IOUtils.toByteArray((InputStream)inputStream)))});
        this.refreshDocument(document);
        try {
            XStorable storable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)document);
            storable.storeToURL("private:stream", new PropertyValue[]{StreamOpenOfficeDocumentConverter.property("FilterName", filterName), StreamOpenOfficeDocumentConverter.property("FilterData", filterData), StreamOpenOfficeDocumentConverter.property("OutputStream", new OutputStreamToXOutputStreamAdapter(outputStream))});
        }
        finally {
            document.dispose();
        }
    }
}

