/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.action.evaluator;

import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.web.action.evaluator.BaseActionEvaluator;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.ml.MultilingualUtils;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.users.UserPreferencesBean;

public class AddTranslationEvaluator
extends BaseActionEvaluator {
    private static final long serialVersionUID = -1513219397606505237L;

    @Override
    public boolean evaluate(Node node) {
        boolean isNodeMultililingal = node.hasAspect(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
        boolean isMLContainer = node.getType().equals((Object)ContentModel.TYPE_MULTILINGUAL_CONTAINER);
        if (isNodeMultililingal || isMLContainer) {
            FacesContext fc = FacesContext.getCurrentInstance();
            if (MultilingualUtils.canAddChildrenToPivotSpace(node, fc)) {
                int contentFilterLanguagesCount;
                MultilingualContentService mlservice = (MultilingualContentService)FacesHelper.getManagedBean(fc, "MultilingualContentService");
                UserPreferencesBean userprefs = (UserPreferencesBean)FacesHelper.getManagedBean(fc, "UserPreferencesBean");
                int availableTranslationCount = mlservice.getTranslations(node.getNodeRef()).size();
                return availableTranslationCount < (contentFilterLanguagesCount = userprefs.getContentFilterLanguages(false).length);
            }
            return false;
        }
        return false;
    }
}

