/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.action.evaluator;

import javax.faces.context.FacesContext;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.action.evaluator.BaseActionEvaluator;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;

public class ForumsCheckinDocEvaluator
extends BaseActionEvaluator {
    private static final long serialVersionUID = -924897450989526336L;

    @Override
    public boolean evaluate(Node node) {
        boolean allow = false;
        if (node.hasAspect(ContentModel.ASPECT_WORKING_COPY) && node.getProperties().get(ContentModel.PROP_WORKING_COPY_MODE) == null) {
            if (node.hasAspect(ForumModel.ASPECT_DISCUSSABLE)) {
                CheckOutCheckInService checkOutCheckInService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getCheckOutCheckInService();
                NodeRef lockedNodeRef = checkOutCheckInService.getCheckedOut(node.getNodeRef());
                if (lockedNodeRef != null) {
                    Node lockedNode = new Node(lockedNodeRef);
                    allow = node.hasPermission("CheckIn") && lockedNode.hasPermission("Contributor");
                }
            } else {
                allow = node.hasPermission("CheckIn");
            }
        }
        return allow;
    }
}

