/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.action.evaluator;

import javax.faces.context.FacesContext;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.action.evaluator.BaseActionEvaluator;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.wcm.AVMBrowseBean;
import org.alfresco.web.bean.wcm.AVMUtil;
import org.alfresco.web.bean.wcm.WebProject;

public class WCMLockEvaluator
extends BaseActionEvaluator {
    private static final long serialVersionUID = -816856825850017138L;

    @Override
    public boolean evaluate(Node node) {
        boolean result = false;
        String path = (String)AVMNodeConverter.ToAVMVersionPath((NodeRef)node.getNodeRef()).getSecond();
        if (!AVMUtil.isMainStore(AVMUtil.getStoreName(path))) {
            FacesContext fc = FacesContext.getCurrentInstance();
            AVMLockingService avmLockService = Repository.getServiceRegistry(fc).getAVMLockingService();
            AVMBrowseBean avmBrowseBean = (AVMBrowseBean)FacesHelper.getManagedBean(fc, "AVMBrowseBean");
            String username = Application.getCurrentUser(fc).getUserName();
            WebProject webProject = avmBrowseBean.getWebProject();
            if (webProject == null) {
                webProject = new WebProject(path);
            }
            result = avmLockService.hasAccess(webProject.getNodeRef(), path, username);
        }
        return result;
    }
}

