/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app;

import java.util.Stack;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.dialog.DialogManager;
import org.alfresco.web.bean.dialog.DialogState;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.wizard.WizardManager;
import org.alfresco.web.bean.wizard.WizardState;
import org.alfresco.web.config.DialogsConfigElement;
import org.alfresco.web.config.NavigationConfigElement;
import org.alfresco.web.config.NavigationResult;
import org.alfresco.web.config.WizardsConfigElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;

public class AlfrescoNavigationHandler
extends NavigationHandler {
    public static final String OUTCOME_SEPARATOR = ":";
    public static final String OUTCOME_BROWSE = "browse";
    public static final String DIALOG_PREFIX = "dialog:";
    public static final String WIZARD_PREFIX = "wizard:";
    public static final String CLOSE_DIALOG_OUTCOME = "dialog:close";
    public static final String CLOSE_WIZARD_OUTCOME = "wizard:close";
    public static final String CLOSE_MULTIPLE_START = "[";
    public static final String CLOSE_MULTIPLE_END = "]";
    public static final String EXTERNAL_CONTAINER_SESSION = "externalDialogContainer";
    protected String dialogContainer = null;
    protected String wizardContainer = null;
    protected String plainDialogContainer = null;
    protected String plainWizardContainer = null;
    private static final Log logger = LogFactory.getLog(AlfrescoNavigationHandler.class);
    private static final String VIEW_STACK = "_alfViewStack";
    private NavigationHandler origHandler;

    public AlfrescoNavigationHandler(NavigationHandler origHandler) {
        this.origHandler = origHandler;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        boolean isDialog;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("handleNavigation (fromAction=" + fromAction + ", outcome=" + outcome + ")"));
            logger.debug((Object)("Current view id: " + context.getViewRoot().getViewId()));
        }
        if ((isDialog = this.isDialog(outcome)) || this.isWizard(outcome)) {
            boolean dialogWizardClosing = this.isDialogOrWizardClosing(outcome);
            outcome = this.stripPrefix(outcome);
            if (dialogWizardClosing) {
                this.handleDialogOrWizardClose(context, fromAction, outcome, isDialog);
            } else if (isDialog) {
                this.handleDialogOpen(context, fromAction, outcome);
            } else {
                this.handleWizardOpen(context, fromAction, outcome);
            }
        } else if (this.isWizardStep(fromAction)) {
            this.goToView(context, this.getWizardContainer(context));
        } else {
            this.handleDispatch(context, fromAction, outcome);
        }
        Object bean = FacesHelper.getManagedBean(context, "NavigationBean");
        if (bean instanceof NavigationBean) {
            ((NavigationBean)bean).resetDispatchContext();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("view stack: " + this.getViewStack(context)));
        }
    }

    protected boolean isDialog(String outcome) {
        boolean dialog = false;
        if (outcome != null && outcome.startsWith(DIALOG_PREFIX)) {
            dialog = true;
        }
        return dialog;
    }

    protected boolean isWizard(String outcome) {
        boolean wizard = false;
        if (outcome != null && outcome.startsWith(WIZARD_PREFIX)) {
            wizard = true;
        }
        return wizard;
    }

    protected boolean isDialogOrWizardClosing(String outcome) {
        boolean closing = false;
        if (outcome != null && (outcome.startsWith(CLOSE_DIALOG_OUTCOME) || outcome.startsWith(CLOSE_WIZARD_OUTCOME))) {
            closing = true;
        }
        return closing;
    }

    protected int getNumberToClose(String outcome) {
        int toClose = 1;
        int idxStart = outcome.indexOf(CLOSE_MULTIPLE_START);
        if (outcome != null && idxStart != -1) {
            block5: {
                int idxEnd = outcome.indexOf(CLOSE_MULTIPLE_END);
                if (idxEnd != -1) {
                    String closeNum = outcome.substring(idxStart + 1, idxEnd);
                    try {
                        toClose = Integer.parseInt(closeNum);
                    }
                    catch (NumberFormatException nfe) {
                        if (!logger.isWarnEnabled()) break block5;
                        logger.warn((Object)"Could not determine number of containers to close, defaulting to 1");
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Closing " + toClose + " levels of container"));
            }
        }
        return toClose;
    }

    protected boolean isWizardStep(String fromAction) {
        boolean wizardStep = false;
        if (fromAction != null && (fromAction.equals("#{WizardManager.next}") || fromAction.equals("#{WizardManager.back}"))) {
            wizardStep = true;
        }
        return wizardStep;
    }

    protected String stripPrefix(String outcome) {
        int idx;
        String newOutcome = outcome;
        if (outcome != null && (idx = outcome.indexOf(OUTCOME_SEPARATOR)) != -1) {
            newOutcome = outcome.substring(idx + 1);
        }
        return newOutcome;
    }

    protected String getOutcomeOverride(String outcome) {
        int idx;
        String override = null;
        if (outcome != null && (idx = outcome.indexOf(OUTCOME_SEPARATOR)) != -1) {
            override = outcome.substring(idx + 1);
        }
        return override;
    }

    protected DialogsConfigElement.DialogConfig getDialogConfig(FacesContext context, String name, Node dispatchContext) {
        DialogsConfigElement dialogsCfg;
        DialogsConfigElement.DialogConfig dialogConfig = null;
        ConfigService configSvc = Application.getConfigService(context);
        Config config = null;
        if (dispatchContext != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using dispatch context for dialog lookup: " + dispatchContext.getType().toString()));
            }
            config = configSvc.getConfig((Object)dispatchContext);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Looking up dialog in global config");
            }
            config = configSvc.getGlobalConfig();
        }
        if (config != null && (dialogsCfg = (DialogsConfigElement)config.getConfigElement("dialogs")) != null) {
            dialogConfig = dialogsCfg.getDialog(name);
        }
        return dialogConfig;
    }

    protected WizardsConfigElement.WizardConfig getWizardConfig(FacesContext context, String name, Node dispatchContext) {
        WizardsConfigElement wizardsCfg;
        WizardsConfigElement.WizardConfig wizardConfig = null;
        ConfigService configSvc = Application.getConfigService(context);
        Config config = null;
        if (dispatchContext != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using dispatch context for wizard lookup: " + dispatchContext.getType().toString()));
            }
            config = configSvc.getConfig((Object)dispatchContext);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Looking up wizard in global config");
            }
            config = configSvc.getGlobalConfig();
        }
        if (config != null && (wizardsCfg = (WizardsConfigElement)config.getConfigElement("wizards")) != null) {
            wizardConfig = wizardsCfg.getWizard(name);
        }
        return wizardConfig;
    }

    protected String getDialogContainer(FacesContext context) {
        String container;
        Object obj = context.getExternalContext().getSessionMap().get(EXTERNAL_CONTAINER_SESSION);
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            ConfigService configSvc;
            Config globalConfig;
            if ((this.plainDialogContainer == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) && (globalConfig = (configSvc = Application.getConfigService(context)).getGlobalConfig()) != null) {
                this.plainDialogContainer = globalConfig.getConfigElement("plain-dialog-container").getValue();
            }
            container = this.plainDialogContainer;
        } else {
            ConfigService configSvc;
            Config globalConfig;
            if ((this.dialogContainer == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) && (globalConfig = (configSvc = Application.getConfigService(context)).getGlobalConfig()) != null) {
                this.dialogContainer = globalConfig.getConfigElement("dialog-container").getValue();
            }
            container = this.dialogContainer;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using dialog container: " + container));
        }
        return container;
    }

    protected String getWizardContainer(FacesContext context) {
        String container;
        Object obj = context.getExternalContext().getSessionMap().get(EXTERNAL_CONTAINER_SESSION);
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            ConfigService configSvc;
            Config globalConfig;
            if ((this.plainWizardContainer == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) && (globalConfig = (configSvc = Application.getConfigService(context)).getGlobalConfig()) != null) {
                this.plainWizardContainer = globalConfig.getConfigElement("plain-wizard-container").getValue();
            }
            container = this.plainWizardContainer;
        } else {
            ConfigService configSvc;
            Config globalConfig;
            if ((this.wizardContainer == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) && (globalConfig = (configSvc = Application.getConfigService(context)).getGlobalConfig()) != null) {
                this.wizardContainer = globalConfig.getConfigElement("wizard-container").getValue();
            }
            container = this.wizardContainer;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using wizard container: " + container));
        }
        return container;
    }

    protected Node getDispatchContextNode(FacesContext context) {
        Node dispatchNode = null;
        NavigationBean navBean = (NavigationBean)context.getExternalContext().getSessionMap().get("NavigationBean");
        if (navBean != null) {
            dispatchNode = navBean.getDispatchContextNode();
        }
        return dispatchNode;
    }

    protected void handleBrowseDispatch(FacesContext context, String fromAction, String outcome) {
        Node dispatchNode = null;
        NavigationBean navBean = (NavigationBean)context.getExternalContext().getSessionMap().get("NavigationBean");
        if (navBean != null) {
            dispatchNode = navBean.getCurrentNode();
        }
        this.handleDispatch(context, fromAction, outcome, dispatchNode);
    }

    protected void handleDispatch(FacesContext context, String fromAction, String outcome) {
        Node dispatchNode = this.getDispatchContextNode(context);
        this.handleDispatch(context, fromAction, outcome, dispatchNode);
    }

    private void handleDispatch(FacesContext context, String fromAction, String outcome, Node dispatchNode) {
        if (dispatchNode != null) {
            NavigationConfigElement navigationCfg;
            String viewId;
            block19: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found node with type '" + dispatchNode.getType().toString() + "' in dispatch context"));
                }
                viewId = context.getViewRoot().getViewId();
                ConfigService configSvc = Application.getConfigService(context);
                navigationCfg = null;
                try {
                    Config nodeConfig = configSvc.getConfig((Object)dispatchNode);
                    navigationCfg = (NavigationConfigElement)nodeConfig.getConfigElement("navigation");
                }
                catch (InvalidNodeRefException e) {
                    if (!logger.isDebugEnabled()) break block19;
                    logger.debug((Object)("Invalid node reference: " + dispatchNode));
                }
            }
            if (navigationCfg != null) {
                NavigationResult navResult = navigationCfg.getOverride(viewId, outcome);
                if (navResult != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found navigation config: " + navResult));
                    }
                    if (navResult.isOutcome()) {
                        this.navigate(context, fromAction, navResult.getResult());
                    } else {
                        String newViewId = navResult.getResult();
                        if (!newViewId.equals(viewId)) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Dispatching to new view id: " + newViewId));
                            }
                            this.goToView(context, newViewId);
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"New view id is the same as the current one so setting outcome to null");
                            }
                            this.navigate(context, fromAction, null);
                        }
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"No override configuration found for current view or outcome");
                    }
                    this.navigate(context, fromAction, outcome);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No navigation configuration found for node");
                }
                this.navigate(context, fromAction, outcome);
            }
            ((NavigationBean)context.getExternalContext().getSessionMap().get("NavigationBean")).resetDispatchContext();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No dispatch context found");
            }
            this.navigate(context, fromAction, outcome);
        }
    }

    protected void handleDialogOpen(FacesContext context, String fromAction, String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Opening dialog '" + name + "'"));
        }
        this.addCurrentViewToStack(context);
        DialogsConfigElement.DialogConfig config = this.getDialogConfig(context, name, this.getDispatchContextNode(context));
        if (config != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found config for dialog '" + name + "': " + config));
            }
            DialogManager dialogManager = Application.getDialogManager();
            dialogManager.setCurrentDialog(config);
            this.goToView(context, this.getDialogContainer(context));
        } else {
            this.handleDispatch(context, fromAction, name);
        }
    }

    protected void handleWizardOpen(FacesContext context, String fromAction, String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Opening wizard '" + name + "'"));
        }
        this.addCurrentViewToStack(context);
        WizardsConfigElement.WizardConfig wizard = this.getWizardConfig(context, name, this.getDispatchContextNode(context));
        if (wizard != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found config for wizard '" + name + "': " + wizard));
            }
            WizardManager wizardManager = Application.getWizardManager();
            wizardManager.setCurrentWizard(wizard);
            this.goToView(context, this.getWizardContainer(context));
        } else {
            this.handleDispatch(context, fromAction, name);
        }
    }

    protected void handleDialogOrWizardClose(FacesContext context, String fromAction, String outcome, boolean dialog) {
        String closingItem;
        String string = closingItem = dialog ? "dialog" : "wizard";
        if (!this.getViewStack(context).empty()) {
            String overriddenOutcome = this.getOutcomeOverride(outcome);
            if (overriddenOutcome == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Closing " + closingItem));
                }
                int numberToClose = this.getNumberToClose(outcome);
                Object stackObject = null;
                if (numberToClose == 1) {
                    stackObject = this.getViewStack(context).pop();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Popped item from the top of the view stack: " + stackObject));
                    }
                } else {
                    Stack viewStack = this.getViewStack(context);
                    int itemsOnStack = viewStack.size();
                    if (itemsOnStack < numberToClose) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Returning to first item on the view stack as there aren't " + numberToClose + " containers to close!"));
                        }
                        numberToClose = itemsOnStack;
                    }
                    for (int x = 1; x <= numberToClose; ++x) {
                        stackObject = viewStack.pop();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Popped item from the stack: " + stackObject));
                    }
                }
                String newViewId = this.getViewIdFromStackObject(context, stackObject);
                this.goToView(context, newViewId);
            } else if (!OUTCOME_BROWSE.equals(overriddenOutcome)) {
                String previousViewId = this.getViewIdFromStackObject(context, this.getViewStack(context).peek());
                this.getViewStack(context).clear();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Closing " + closingItem + " with an overridden outcome of '" + overriddenOutcome + "'"));
                }
                if (this.isDialog(overriddenOutcome) || this.isWizard(overriddenOutcome)) {
                    context.getViewRoot().setViewId(previousViewId);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("view stack: " + this.getViewStack(context)));
                        logger.debug((Object)("Opening '" + overriddenOutcome + "' after " + closingItem + " close using view id: " + previousViewId));
                    }
                    this.handleNavigation(context, fromAction, overriddenOutcome);
                } else {
                    this.navigate(context, fromAction, overriddenOutcome);
                }
            } else {
                this.handleBrowseDispatch(context, fromAction, overriddenOutcome);
                this.getViewStack(context).clear();
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting to close a " + closingItem + " with an empty view stack, returning 'browse' outcome"));
            }
            this.navigate(context, fromAction, OUTCOME_BROWSE);
        }
    }

    protected String getViewIdFromStackObject(FacesContext context, Object topOfStack) {
        String viewId = null;
        if (topOfStack instanceof String) {
            viewId = (String)topOfStack;
        } else if (topOfStack instanceof DialogState) {
            Application.getDialogManager().restoreState((DialogState)topOfStack);
            viewId = this.getDialogContainer(context);
        } else if (topOfStack instanceof WizardState) {
            Application.getWizardManager().restoreState((WizardState)topOfStack);
            viewId = this.getWizardContainer(context);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)("Invalid object found on view stack: " + topOfStack));
        }
        return viewId;
    }

    protected void addCurrentViewToStack(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String dialogContainer = this.getDialogContainer(context);
        String wizardContainer = this.getWizardContainer(context);
        Object objectForStack = null;
        if (viewId.equals(dialogContainer)) {
            DialogManager dlgMgr = Application.getDialogManager();
            objectForStack = dlgMgr.getState();
        } else if (viewId.equals(wizardContainer)) {
            WizardManager wizMgr = Application.getWizardManager();
            objectForStack = wizMgr.getState();
        } else {
            objectForStack = viewId;
        }
        Stack stack = this.getViewStack(context);
        if (stack.empty()) {
            stack.push(objectForStack);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Pushed item to view stack: " + objectForStack));
            }
        } else {
            Object topOfStack = stack.peek();
            if (objectForStack instanceof String && topOfStack instanceof String && topOfStack.equals(objectForStack)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"current view is already top of the view stack!");
                }
            } else {
                stack.push(objectForStack);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Pushed item to view stack: " + objectForStack));
                }
            }
        }
    }

    private void navigate(FacesContext context, String fromAction, String outcome) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Passing outcome '" + outcome + "' to original navigation handler"));
        }
        this.origHandler.handleNavigation(context, fromAction, outcome);
    }

    private void goToView(FacesContext context, String viewId) {
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        UIViewRoot viewRoot = viewHandler.createView(context, viewId);
        viewRoot.setViewId(viewId);
        context.setViewRoot(viewRoot);
        context.renderResponse();
    }

    private Stack getViewStack(FacesContext context) {
        Stack viewStack = (Stack)context.getExternalContext().getSessionMap().get(VIEW_STACK);
        if (viewStack == null) {
            viewStack = new Stack();
            context.getExternalContext().getSessionMap().put(VIEW_STACK, viewStack);
        }
        return viewStack;
    }
}

