/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app;

import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import org.alfresco.web.app.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigService;
import org.springframework.web.jsf.DelegatingVariableResolver;

public class AlfrescoVariableResolver
extends DelegatingVariableResolver {
    protected List<String> dialogContainers = null;
    protected List<String> wizardContainers = null;
    private static final String CONTAINER = "Container";
    private static final Log logger = LogFactory.getLog(AlfrescoVariableResolver.class);

    public AlfrescoVariableResolver(VariableResolver originalVariableResolver) {
        super(originalVariableResolver);
    }

    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {
        Object variable = super.resolveVariable(context, name);
        if (variable == null && name.equals(CONTAINER)) {
            String viewId = context.getViewRoot().getViewId();
            List<String> dialogContainers = this.getDialogContainers(context);
            List<String> wizardContainers = this.getWizardContainers(context);
            if (dialogContainers.contains(viewId)) {
                variable = Application.getDialogManager();
            } else if (wizardContainers.contains(viewId)) {
                variable = Application.getWizardManager();
            }
            if (variable != null && logger.isDebugEnabled()) {
                logger.debug((Object)("Resolved 'Container' variable to: " + variable));
            }
        }
        return variable;
    }

    protected List<String> getDialogContainers(FacesContext context) {
        if (this.dialogContainers == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            this.dialogContainers = new ArrayList<String>(2);
            ConfigService configSvc = Application.getConfigService(context);
            Config globalConfig = configSvc.getGlobalConfig();
            if (globalConfig != null) {
                this.dialogContainers.add(globalConfig.getConfigElement("dialog-container").getValue());
                this.dialogContainers.add(globalConfig.getConfigElement("plain-dialog-container").getValue());
            }
        }
        return this.dialogContainers;
    }

    protected List<String> getWizardContainers(FacesContext context) {
        if (this.wizardContainers == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            this.wizardContainers = new ArrayList<String>(2);
            ConfigService configSvc = Application.getConfigService(context);
            Config globalConfig = configSvc.getGlobalConfig();
            if (globalConfig != null) {
                this.wizardContainers.add(globalConfig.getConfigElement("wizard-container").getValue());
                this.wizardContainers.add(globalConfig.getConfigElement("plain-wizard-container").getValue());
            }
        }
        return this.wizardContainers;
    }
}

