/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.faces.context.FacesContext;
import org.alfresco.repo.i18n.MessageService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.web.bean.repository.Repository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.jsf.FacesContextUtils;

public final class ResourceBundleWrapper
extends ResourceBundle
implements Serializable {
    private static final long serialVersionUID = -3230653664902689948L;
    private static Log logger = LogFactory.getLog(ResourceBundleWrapper.class);
    private static List<String> addedBundleNames = new ArrayList<String>(10);
    private final Locale locale;
    private final String bundleName;
    private transient List<ResourceBundle> delegates;
    private transient MessageService messageService;
    public static final String BEAN_RESOURCE_MESSAGE_SERVICE = "messageService";
    public static final String PATH = "app:company_home/app:dictionary/app:webclient_extension";

    private ResourceBundleWrapper(Locale locale, String bundleName) {
        this.locale = locale;
        this.bundleName = bundleName;
    }

    private MessageService getMessageService() {
        if (this.messageService == null && FacesContext.getCurrentInstance() != null) {
            this.messageService = (MessageService)FacesContextUtils.getRequiredWebApplicationContext((FacesContext)FacesContext.getCurrentInstance()).getBean(BEAN_RESOURCE_MESSAGE_SERVICE);
        }
        return this.messageService;
    }

    private List<ResourceBundle> getDelegates() {
        if (this.delegates == null) {
            this.delegates = new ArrayList<ResourceBundle>(addedBundleNames.size() + 2);
            ResourceBundle customBundle = null;
            if (this.getMessageService() != null) {
                StoreRef storeRef = null;
                String path = null;
                try {
                    String customName = null;
                    int idx = this.bundleName.lastIndexOf(".");
                    customName = idx != -1 ? this.bundleName.substring(idx + 1, this.bundleName.length()) : this.bundleName;
                    storeRef = Repository.getStoreRef();
                    path = "app:company_home/app:dictionary/app:webclient_extension/cm:" + customName;
                    customBundle = this.getMessageService().getRepoResourceBundle(Repository.getStoreRef(), path, this.locale);
                }
                catch (Throwable t) {
                    logger.debug((Object)("Custom Web Client properties not found: " + storeRef + path));
                }
            }
            if (customBundle == null) {
                String customName = ResourceBundleWrapper.determineCustomBundleName(this.bundleName);
                customBundle = this.getResourceBundle(this.locale, customName);
            }
            if (customBundle != null) {
                this.delegates.add(customBundle);
            }
            this.delegates.add(this.getResourceBundle(this.locale, this.bundleName));
            for (String addedBundleName : addedBundleNames) {
                this.delegates.add(this.getResourceBundle(this.locale, addedBundleName));
            }
        }
        return this.delegates;
    }

    private ResourceBundle getResourceBundle(Locale locale, String bundleName) {
        ResourceBundle bundle;
        block3: {
            bundle = null;
            try {
                bundle = ResourceBundle.getBundle(bundleName, locale);
                this.delegates.add(bundle);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Located and loaded bundle " + bundleName));
                }
            }
            catch (MissingResourceException mre) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("Unable to load bundle " + bundleName));
            }
        }
        return bundle;
    }

    @Override
    public Enumeration<String> getKeys() {
        if (this.getDelegates().size() == 1) {
            return this.getDelegates().get(0).getKeys();
        }
        Vector<String> allKeys = new Vector<String>(100, 2);
        for (ResourceBundle delegate : this.getDelegates()) {
            Enumeration<String> keys = delegate.getKeys();
            while (keys.hasMoreElements()) {
                allKeys.add(keys.nextElement());
            }
        }
        return allKeys.elements();
    }

    @Override
    protected Object handleGetObject(String key) {
        Object result = null;
        for (ResourceBundle delegate : this.getDelegates()) {
            try {
                result = delegate.getObject(key);
                if (result == null) continue;
                break;
            }
            catch (MissingResourceException mre) {
            }
        }
        if (result == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Failed to find I18N message key: " + key + " for locale: " + this.locale.toString()));
            }
            result = "$$" + key + "$$";
        }
        return result;
    }

    public static ResourceBundle getResourceBundle(String name, Locale locale) {
        return new ResourceBundleWrapper(locale, name);
    }

    public static void addResourceBundle(String name) {
        addedBundleNames.add(name);
    }

    protected static String determineCustomBundleName(String bundleName) {
        String extensionPackage = "alfresco.extension.";
        String customBundleName = null;
        int idx = bundleName.lastIndexOf(".");
        customBundleName = idx == -1 ? extensionPackage + bundleName : extensionPackage + bundleName.substring(idx + 1, bundleName.length());
        return customBundleName;
    }
}

