/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.context;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.alfresco.web.app.context.IContextListener;

public final class UIContextService
implements Serializable {
    private static final long serialVersionUID = -866750823190499704L;
    private static final String CONTEXT_KEY = "__uiContextService";
    private Map<Class, IContextListener> registeredBeans = new HashMap<Class, IContextListener>(7, 1.0f);

    private UIContextService() {
    }

    public static UIContextService getInstance(FacesContext fc) {
        Map session = fc.getExternalContext().getSessionMap();
        UIContextService service = (UIContextService)session.get(CONTEXT_KEY);
        if (service == null) {
            service = new UIContextService();
            session.put(CONTEXT_KEY, service);
        }
        return service;
    }

    public void registerBean(IContextListener bean) {
        if (bean == null) {
            throw new IllegalArgumentException("Bean reference specified cannot be null!");
        }
        this.registeredBeans.put(bean.getClass(), bean);
    }

    public void unregisterBean(IContextListener bean) {
        if (bean == null) {
            throw new IllegalArgumentException("Bean reference specified cannot be null!");
        }
        this.registeredBeans.remove(bean);
    }

    public IContextListener getRegisteredBean(String className) {
        IContextListener bean = null;
        for (Class clazz : this.registeredBeans.keySet()) {
            if (!clazz.getName().equals(className)) continue;
            bean = this.registeredBeans.get(clazz);
            break;
        }
        return bean;
    }

    public void notifyBeans() {
        for (IContextListener listener : this.registeredBeans.values()) {
            listener.contextUpdated();
        }
    }

    public void spaceChanged() {
        for (IContextListener listener : this.registeredBeans.values()) {
            listener.spaceChanged();
        }
    }

    public void areaChanged() {
        for (IContextListener listener : this.registeredBeans.values()) {
            listener.areaChanged();
        }
    }
}

