/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.portlet;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceURL;
import javax.portlet.UnavailableException;
import javax.servlet.ServletRequest;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.util.TempFileProvider;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.portlet.AlfrescoDefaultViewSelector;
import org.alfresco.web.app.servlet.AuthenticationHelper;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.ErrorBean;
import org.alfresco.web.bean.FileUploadBean;
import org.alfresco.web.bean.LoginBean;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.config.ClientConfigElement;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.portlet.MyFacesGenericPortlet;
import org.apache.myfaces.portlet.PortletUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.web.context.WebApplicationContext;

public class AlfrescoFacesPortlet
extends MyFacesGenericPortlet {
    private static final String ATTRIBUTE_LOCALE = "locale";
    private static final String PREF_ALF_USERNAME = "_alfUserName";
    private static final String SESSION_LAST_VIEW_ID = "_alfLastViewId";
    private static final String ERROR_OCCURRED = "error-occurred";
    private static Log logger = LogFactory.getLog(AlfrescoFacesPortlet.class);
    private String loginPage = null;
    private String errorPage = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        block21: {
            Application.setInPortalServer(true);
            try {
                I18NUtil.setLocale((Locale)AlfrescoFacesPortlet.getLanguage(request.getPortletSession()));
                boolean isMultipart = PortletFileUpload.isMultipartContent((ActionRequest)request);
                if (isMultipart) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Handling multipart request...");
                    }
                    PortletSession session = request.getPortletSession();
                    DiskFileItemFactory factory = new DiskFileItemFactory();
                    PortletFileUpload upload = new PortletFileUpload((FileItemFactory)factory);
                    List fileItems = upload.parseRequest(request);
                    Iterator iter = fileItems.iterator();
                    FileUploadBean bean = new FileUploadBean();
                    while (iter.hasNext()) {
                        int idx;
                        FileItem item = (FileItem)iter.next();
                        String filename = item.getName();
                        if (item.isFormField()) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Processing uploaded file: " + filename));
                        }
                        if ((idx = filename.lastIndexOf(92)) == -1) {
                            idx = filename.lastIndexOf(47);
                        }
                        if (idx != -1) {
                            filename = filename.substring(idx + File.separator.length());
                        }
                        File tempFile = TempFileProvider.createTempFile((String)"alfresco", (String)".upload");
                        item.write(tempFile);
                        bean.setFile(tempFile);
                        bean.setFileName(filename);
                        bean.setFilePath(tempFile.getAbsolutePath());
                        session.setAttribute("alfresco.UploadBean", (Object)bean, 2);
                    }
                    String lastViewId = (String)request.getPortletSession().getAttribute(SESSION_LAST_VIEW_ID);
                    if (lastViewId != null) {
                        response.setRenderParameter(VIEW_ID, lastViewId);
                    }
                } else {
                    User user;
                    SessionUser sessionUser = (SessionUser)request.getPortletSession().getAttribute("_alfAuthTicket", 1);
                    User user2 = user = sessionUser instanceof User ? (User)sessionUser : null;
                    if (user != null) {
                        try {
                            String oldValue;
                            WebApplicationContext ctx = (WebApplicationContext)this.getPortletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
                            AuthenticationService auth = (AuthenticationService)ctx.getBean("AuthenticationService");
                            auth.validate(user.getTicket());
                            LoginBean loginBean = (LoginBean)request.getPortletSession().getAttribute("LoginBean");
                            if (!(loginBean == null || (oldValue = request.getPreferences().getValue(PREF_ALF_USERNAME, null)) != null && oldValue.equals(loginBean.getUsernameInternal()) || request.getPreferences().isReadOnly(PREF_ALF_USERNAME))) {
                                request.getPreferences().setValue(PREF_ALF_USERNAME, loginBean.getUsernameInternal());
                                request.getPreferences().store();
                            }
                            super.processAction(request, response);
                        }
                        catch (AuthenticationException authErr) {
                            request.getPortletSession().removeAttribute("_alfAuthTicket", 1);
                        }
                    } else {
                        super.processAction(request, response);
                    }
                }
            }
            catch (Throwable e) {
                if (this.getErrorPage() != null) {
                    this.handleError(request, response, e);
                    break block21;
                }
                logger.warn((Object)"No error page configured, re-throwing exception");
                if (e instanceof PortletException) {
                    throw (PortletException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new PortletException(e);
            }
            finally {
                Application.setInPortalServer(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        Application.setInPortalServer(true);
        try {
            super.serveResource(request, response);
        }
        finally {
            Application.setInPortalServer(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void facesRender(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        block23: {
            Application.setInPortalServer(true);
            try {
                User user;
                I18NUtil.setLocale((Locale)AlfrescoFacesPortlet.getLanguage(request.getPortletSession()));
                if (request.getParameter(ERROR_OCCURRED) != null) {
                    String errorPage = this.getErrorPage();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("An error has occurred, redirecting to error page: " + errorPage));
                    }
                    response.setContentType("text/html");
                    PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(errorPage);
                    dispatcher.include(request, response);
                    break block23;
                }
                WebApplicationContext ctx = (WebApplicationContext)this.getPortletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
                AuthenticationService auth = (AuthenticationService)ctx.getBean("AuthenticationService");
                PortletSession session = request.getPortletSession();
                String viewId = request.getParameter(VIEW_ID);
                request.getPortletSession().setAttribute(SESSION_LAST_VIEW_ID, (Object)viewId);
                SessionUser sessionUser = (SessionUser)request.getPortletSession().getAttribute("_alfAuthTicket", 1);
                User user2 = user = sessionUser instanceof User ? (User)sessionUser : null;
                if (!(user != null || viewId != null && viewId.equals(this.getLoginPage()))) {
                    if (AlfrescoFacesPortlet.portalGuestAuthenticate(ctx, session, auth) != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Guest access successful.");
                        }
                        response.setContentType("text/html");
                        request.getPortletSession().setAttribute(PortletUtil.PORTLET_REQUEST_FLAG, (Object)"true");
                        ConfigService configService = (ConfigService)ctx.getBean("webClientConfigService");
                        ClientConfigElement configElement = (ClientConfigElement)configService.getGlobalConfig().getConfigElement("client");
                        if ("myalfresco".equals(configElement.getInitialLocation())) {
                            this.nonFacesRequest(request, response, "/jsp/dashboards/container.jsp");
                        } else {
                            this.nonFacesRequest(request, response, "/jsp/browse/browse.jsp");
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("No valid User login, requesting login page. ViewId: " + viewId));
                        }
                        session.setAttribute("_alfLastUser", (Object)request.getPreferences().getValue(PREF_ALF_USERNAME, null));
                        response.setContentType("text/html");
                        request.getPortletSession().setAttribute(PortletUtil.PORTLET_REQUEST_FLAG, (Object)"true");
                        this.nonFacesRequest(request, response);
                    }
                    break block23;
                }
                if (session.getAttribute("_alfSessionInvalid") != null) {
                    if (!request.getPreferences().isReadOnly(PREF_ALF_USERNAME)) {
                        request.getPreferences().reset(PREF_ALF_USERNAME);
                    }
                    session.removeAttribute("_alfSessionInvalid");
                }
                try {
                    if (user != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Validating ticket: " + user.getTicket()));
                        }
                        auth.validate(user.getTicket());
                    }
                    super.facesRender(request, response);
                }
                catch (AuthenticationException authErr) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Invalid ticket, requesting login page.");
                    }
                    session.removeAttribute("_alfAuthTicket", 1);
                    response.setContentType("text/html");
                    request.getPortletSession().setAttribute(PortletUtil.PORTLET_REQUEST_FLAG, (Object)"true");
                    this.nonFacesRequest(request, response);
                }
                catch (Throwable e) {
                    if (this.getErrorPage() != null) {
                        this.handleError(request, response, e);
                        break block23;
                    }
                    logger.warn((Object)"No error page configured, re-throwing exception");
                    if (e instanceof PortletException) {
                        throw (PortletException)e;
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new PortletException(e);
                }
            }
            finally {
                Application.setInPortalServer(false);
            }
        }
    }

    private void handleError(ActionRequest request, ActionResponse response, Throwable error) throws PortletException, IOException {
        PortletSession session = request.getPortletSession();
        ErrorBean errorBean = (ErrorBean)session.getAttribute("alfresco.ErrorBean", 2);
        if (errorBean == null) {
            errorBean = new ErrorBean();
            session.setAttribute("alfresco.ErrorBean", (Object)errorBean, 2);
        }
        errorBean.setLastError(error);
        response.setRenderParameter(ERROR_OCCURRED, "true");
    }

    public static ErrorBean getErrorBean(ServletRequest request) {
        PortletSession session;
        PortletRequest portletReq = (PortletRequest)request.getAttribute("javax.portlet.request");
        if (portletReq != null && (session = portletReq.getPortletSession(false)) != null) {
            return (ErrorBean)session.getAttribute("alfresco.ErrorBean");
        }
        return null;
    }

    public static String getRenderURL(ServletRequest request, Map<String, String[]> parameters) {
        RenderResponse renderResp = (RenderResponse)request.getAttribute("javax.portlet.response");
        if (renderResp == null) {
            throw new IllegalStateException("RenderResponse object is null");
        }
        PortletURL url = renderResp.createRenderURL();
        url.setParameters(parameters);
        return url.toString();
    }

    public static String getActionURL(ServletRequest request) {
        RenderResponse renderResp = (RenderResponse)request.getAttribute("javax.portlet.response");
        if (renderResp == null) {
            throw new IllegalStateException("RenderResponse object is null. The web application is not executing within a portal server!");
        }
        return renderResp.createActionURL().toString();
    }

    public static String getResourceURL(FacesContext context, String path) {
        MimeResponse portletResponse = (MimeResponse)context.getExternalContext().getResponse();
        ResourceURL resourceURL = portletResponse.createResourceURL();
        resourceURL.setResourceID(path);
        return resourceURL.toString();
    }

    public static Object getPortletSessionAttribute(FacesContext context, String attributeName, boolean shared) {
        PortletSession session;
        Object portletReq = context.getExternalContext().getRequest();
        if (portletReq != null && portletReq instanceof PortletRequest && (session = ((PortletRequest)portletReq).getPortletSession(false)) != null) {
            return session.getAttribute(attributeName, shared ? 1 : 2);
        }
        return null;
    }

    public static void setPortletSessionAttribute(FacesContext context, String attributeName, Object value, boolean shared) {
        Object portletReq = context.getExternalContext().getRequest();
        if (portletReq != null && portletReq instanceof PortletRequest) {
            PortletSession session = ((PortletRequest)portletReq).getPortletSession();
            session.setAttribute(attributeName, value, shared ? 1 : 2);
        } else {
            context.getExternalContext().getSessionMap().put(attributeName, value);
        }
    }

    public static FacesContext getFacesContext(ServletRequest request) {
        PortletRequest portletReq = (PortletRequest)request.getAttribute("javax.portlet.request");
        PortletResponse portletRes = (PortletResponse)request.getAttribute("javax.portlet.response");
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        return FacesHelper.getFacesContext(portletReq, portletRes, portletConfig.getPortletContext());
    }

    public static String onLogOut(Object req) {
        PortletRequest portletReq = null;
        if (req instanceof ServletRequest) {
            portletReq = (PortletRequest)((ServletRequest)req).getAttribute("javax.portlet.request");
        } else if (req instanceof PortletRequest) {
            portletReq = (PortletRequest)req;
        }
        if (portletReq == null) {
            return null;
        }
        PortletSession session = portletReq.getPortletSession();
        SessionUser user = (SessionUser)session.getAttribute("_alfAuthTicket", 1);
        Enumeration i = session.getAttributeNames();
        while (i.hasMoreElements()) {
            session.removeAttribute((String)i.nextElement());
        }
        session.setAttribute("_alfSessionInvalid", (Object)true);
        return user == null ? null : user.getTicket();
    }

    private void handleError(RenderRequest request, RenderResponse response, Throwable error) throws PortletException, IOException {
        PortletSession session = request.getPortletSession();
        ErrorBean errorBean = (ErrorBean)session.getAttribute("alfresco.ErrorBean", 2);
        if (errorBean == null) {
            errorBean = new ErrorBean();
            session.setAttribute("alfresco.ErrorBean", (Object)errorBean, 2);
        }
        errorBean.setLastError(error);
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            UIViewRoot view = viewHandler.createView(context, "/jsp/browse/browse.jsp");
            context.setViewRoot(view);
        }
        String errorPage = this.getErrorPage();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("An error has occurred, redirecting to error page: " + errorPage));
        }
        response.setContentType("text/html");
        PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(errorPage);
        dispatcher.include(request, response);
    }

    protected void setDefaultViewSelector() throws UnavailableException {
        super.setDefaultViewSelector();
        if (this.defaultViewSelector == null) {
            this.defaultViewSelector = new AlfrescoDefaultViewSelector();
        }
    }

    private static User portalGuestAuthenticate(WebApplicationContext ctx, PortletSession session, AuthenticationService auth) {
        User user = AuthenticationHelper.portalGuestAuthenticate(ctx, auth);
        if (user != null) {
            session.setAttribute("_alfAuthTicket", (Object)user, 1);
            I18NUtil.setLocale((Locale)AlfrescoFacesPortlet.getLanguage(session));
            session.removeAttribute("_alfSessionInvalid");
        }
        return user;
    }

    private static Locale getLanguage(PortletSession session) {
        Locale locale = (Locale)session.getAttribute(ATTRIBUTE_LOCALE);
        if (locale == null) {
            locale = Application.getLanguage((ApplicationContext)session.getPortletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE));
            session.setAttribute(ATTRIBUTE_LOCALE, (Object)locale);
        }
        return locale;
    }

    private String getLoginPage() {
        if (this.loginPage == null) {
            this.loginPage = Application.getLoginPage((ApplicationContext)this.getPortletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE));
        }
        return this.loginPage;
    }

    private String getErrorPage() {
        if (this.errorPage == null) {
            this.errorPage = Application.getErrorPage((ApplicationContext)this.getPortletContext().getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE));
        }
        return this.errorPage;
    }
}

