/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.web.app.servlet.AcceptLanguage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractAuthenticationFilter
implements Filter {
    private static Log logger = LogFactory.getLog(AbstractAuthenticationFilter.class);
    static final String NO_AUTH_REQUIRED = "alfNoAuthRequired";

    public static final Locale parseAcceptLanguageHeader(HttpServletRequest req, List<String> m_languages) {
        Locale locale = Locale.getDefault();
        String acceptHeader = req.getHeader("Accept-Language");
        if (acceptHeader != null) {
            StringTokenizer tokens = new StringTokenizer(acceptHeader, ",");
            ArrayList<AcceptLanguage> langList = new ArrayList<AcceptLanguage>();
            while (tokens.hasMoreTokens()) {
                String lang = tokens.nextToken();
                float quality = 1.0f;
                int qpos = lang.indexOf(";");
                if (qpos != -1) {
                    try {
                        quality = Float.parseFloat(lang.substring(qpos + 3));
                    }
                    catch (NumberFormatException ex) {
                        logger.error((Object)("Error parsing Accept-Language value " + lang));
                    }
                    lang = lang.substring(0, qpos);
                }
                langList.add(new AcceptLanguage(lang, quality));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Accept-Language list : " + langList));
            }
            if (langList.size() > 0) {
                Locale useLocale;
                AcceptLanguage useLang = null;
                String useName = null;
                boolean match = false;
                for (AcceptLanguage curLang : langList) {
                    for (String availLang : m_languages) {
                        match = false;
                        if (curLang.getLanguage().length() == 2) {
                            if (availLang.startsWith(curLang.getLanguage())) {
                                match = true;
                            }
                        } else if (availLang.equalsIgnoreCase(curLang.getLanguage())) {
                            match = true;
                        }
                        if (!match || useLang != null && !(curLang.getQuality() > useLang.getQuality())) continue;
                        useLang = curLang;
                        useName = availLang;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Accept-Language using " + (useLang != null ? useLang.toString() : "<none>")));
                }
                if (useLang != null && (useLocale = AcceptLanguage.createLocale(useName)) != null) {
                    locale = useLocale;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using language " + useLang + ", locale " + locale));
                    }
                }
            }
        }
        return locale;
    }
}

