/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.auth.RemoteUserMapper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.portlet.AlfrescoFacesPortlet;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.LoginBean;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.users.UserPreferencesBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class AuthenticationHelper {
    public static final String AUTHENTICATION_USER = "_alfAuthTicket";
    public static final String SESSION_USERNAME = "_alfLastUser";
    public static final String SESSION_INVALIDATED = "_alfSessionInvalid";
    public static final String LOGIN_BEAN = "LoginBean";
    private static final String AUTHENTICATION_SERVICE = "AuthenticationService";
    private static final String AUTHENTICATION_COMPONENT = "AuthenticationComponent";
    private static final String REMOTE_USER_MAPPER = "RemoteUserMapper";
    private static final String UNPROTECTED_AUTH_SERVICE = "authenticationService";
    private static final String PERSON_SERVICE = "personService";
    private static final String COOKIE_ALFUSER = "alfUser0";
    private static Log logger = LogFactory.getLog(AuthenticationHelper.class);

    public static void setupThread(ServletContext sc, HttpServletRequest req, HttpServletResponse res, boolean useInterfaceLanguage) {
        FacesContext fc = Application.inPortalServer() ? AlfrescoFacesPortlet.getFacesContext((ServletRequest)req) : FacesHelper.getFacesContext((ServletRequest)req, (ServletResponse)res, sc);
        I18NUtil.setLocale((Locale)Application.getLanguage(req.getSession(), Application.getClientConfig(fc).isLanguageSelect() && useInterfaceLanguage));
        UserPreferencesBean userPreferencesBean = (UserPreferencesBean)FacesHelper.getManagedBean(fc, "UserPreferencesBean");
        if (userPreferencesBean != null) {
            String contentFilterLanguageStr = userPreferencesBean.getContentFilterLanguage();
            if (contentFilterLanguageStr != null) {
                I18NUtil.setContentLocale((Locale)I18NUtil.parseLocale((String)contentFilterLanguageStr));
            } else {
                I18NUtil.setContentLocale(null);
            }
        }
    }

    public static AuthenticationStatus authenticate(ServletContext sc, HttpServletRequest req, HttpServletResponse res, boolean forceGuest) throws IOException {
        return AuthenticationHelper.authenticate(sc, req, res, forceGuest, true);
    }

    public static AuthenticationStatus authenticate(ServletContext sc, HttpServletRequest req, HttpServletResponse res, boolean forceGuest, boolean allowGuest) throws IOException {
        String loginName;
        User user = AuthenticationHelper.getUser(sc, req, res);
        HttpSession session = req.getSession();
        LoginBean loginBean = null;
        if (!Application.inPortalServer()) {
            loginBean = (LoginBean)session.getAttribute(LOGIN_BEAN);
        }
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        AuthenticationService auth = (AuthenticationService)wc.getBean(AUTHENTICATION_SERVICE);
        if (user == null || forceGuest) {
            if (session.getAttribute(SESSION_INVALIDATED) == null) {
                Cookie authCookie = AuthenticationHelper.getAuthCookie(req);
                if (allowGuest && (authCookie == null || forceGuest)) {
                    try {
                        auth.authenticateAsGuest();
                        AuthenticationHelper.setUser(sc, req, AuthenticationUtil.getGuestUserName(), auth.getCurrentTicket(), false);
                        AuthenticationHelper.setupThread(sc, req, res, true);
                        session.removeAttribute(SESSION_INVALIDATED);
                        return AuthenticationStatus.Guest;
                    }
                    catch (AuthenticationException guestError) {
                    }
                    catch (AccessDeniedException accessError) {
                        AuthenticationService unprotAuthService = (AuthenticationService)wc.getBean(UNPROTECTED_AUTH_SERVICE);
                        unprotAuthService.invalidateTicket(unprotAuthService.getCurrentTicket());
                        unprotAuthService.clearCurrentSecurityContext();
                        logger.warn((Object)("Unable to login as Guest: " + accessError.getMessage()));
                    }
                    catch (Throwable e) {
                        AuthenticationService unprotAuthService = (AuthenticationService)wc.getBean(UNPROTECTED_AUTH_SERVICE);
                        unprotAuthService.invalidateTicket(unprotAuthService.getCurrentTicket());
                        unprotAuthService.clearCurrentSecurityContext();
                        throw new AlfrescoRuntimeException("Failed to authenticate as Guest user.", e);
                    }
                }
            }
            return AuthenticationStatus.Failure;
        }
        if (loginBean != null && (loginName = loginBean.getUsernameInternal()) != null) {
            AuthenticationHelper.setUsernameCookie(req, res, loginName);
        }
        AuthenticationHelper.setupThread(sc, req, res, true);
        return AuthenticationStatus.Success;
    }

    public static AuthenticationStatus authenticate(ServletContext context, HttpServletRequest httpRequest, HttpServletResponse httpResponse, String ticket) throws IOException {
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
        AuthenticationService auth = (AuthenticationService)wc.getBean(AUTHENTICATION_SERVICE);
        HttpSession session = httpRequest.getSession();
        try {
            SessionUser user = (SessionUser)session.getAttribute(AUTHENTICATION_USER);
            if (user != null && !user.getTicket().equals(ticket)) {
                session.removeAttribute(AUTHENTICATION_USER);
                if (!Application.inPortalServer()) {
                    session.invalidate();
                    session = httpRequest.getSession();
                }
                user = null;
            }
            auth.validate(ticket);
            if (user == null) {
                AuthenticationHelper.setUser(context, httpRequest, auth.getCurrentUserName(), ticket, false);
            }
        }
        catch (AuthenticationException authErr) {
            session.removeAttribute(AUTHENTICATION_USER);
            if (!Application.inPortalServer()) {
                session.invalidate();
            }
            return AuthenticationStatus.Failure;
        }
        catch (Throwable e) {
            AuthenticationService unprotAuthService = (AuthenticationService)wc.getBean(UNPROTECTED_AUTH_SERVICE);
            unprotAuthService.invalidateTicket(unprotAuthService.getCurrentTicket());
            unprotAuthService.clearCurrentSecurityContext();
            return AuthenticationStatus.Failure;
        }
        AuthenticationHelper.setupThread(context, httpRequest, httpResponse, false);
        return AuthenticationStatus.Success;
    }

    public static User setUser(ServletContext context, HttpServletRequest req, String currentUsername, String ticket, boolean externalAuth) {
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)context);
        User user = AuthenticationHelper.createUser(wc, currentUsername, ticket);
        HttpSession session = req.getSession(true);
        session.setAttribute(AUTHENTICATION_USER, (Object)user);
        AuthenticationHelper.setExternalAuth(session, externalAuth);
        return user;
    }

    private static void setExternalAuth(HttpSession session, boolean externalAuth) {
        if (externalAuth) {
            session.setAttribute("_alfExternalAuth", (Object)Boolean.TRUE);
        } else {
            session.removeAttribute("_alfExternalAuth");
        }
    }

    private static User createUser(final WebApplicationContext wc, final String currentUsername, final String ticket) {
        final ServiceRegistry services = (ServiceRegistry)wc.getBean("ServiceRegistry");
        return (User)services.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<User>(){

            public User execute() throws Throwable {
                NodeService nodeService = services.getNodeService();
                PersonService personService = (PersonService)wc.getBean(AuthenticationHelper.PERSON_SERVICE);
                NodeRef personRef = personService.getPerson(currentUsername);
                User user = new User(currentUsername, ticket, personRef);
                NodeRef homeRef = (NodeRef)nodeService.getProperty(personRef, ContentModel.PROP_HOMEFOLDER);
                if (!nodeService.exists(homeRef)) {
                    throw new InvalidNodeRefException(homeRef);
                }
                user.setHomeSpaceId(homeRef.getId());
                return user;
            }
        });
    }

    public static User portalGuestAuthenticate(WebApplicationContext ctx, AuthenticationService auth) {
        try {
            auth.authenticateAsGuest();
            return AuthenticationHelper.createUser(ctx, AuthenticationUtil.getGuestUserName(), auth.getCurrentTicket());
        }
        catch (AuthenticationException guestError) {
        }
        catch (AccessDeniedException accessError) {
            AuthenticationService unprotAuthService = (AuthenticationService)ctx.getBean(UNPROTECTED_AUTH_SERVICE);
            unprotAuthService.invalidateTicket(unprotAuthService.getCurrentTicket());
            unprotAuthService.clearCurrentSecurityContext();
            logger.warn((Object)("Unable to login as Guest: " + accessError.getMessage()));
        }
        catch (Throwable e) {
            AuthenticationService unprotAuthService = (AuthenticationService)ctx.getBean(UNPROTECTED_AUTH_SERVICE);
            unprotAuthService.invalidateTicket(unprotAuthService.getCurrentTicket());
            unprotAuthService.clearCurrentSecurityContext();
            throw new AlfrescoRuntimeException("Failed to authenticate as Guest user.", e);
        }
        return null;
    }

    public static String getRemoteUser(ServletContext sc, HttpServletRequest httpRequest) {
        String userId = null;
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
        RemoteUserMapper remoteUserMapper = (RemoteUserMapper)wc.getBean(REMOTE_USER_MAPPER);
        if (!(remoteUserMapper instanceof ActivateableBean) || ((ActivateableBean)remoteUserMapper).isActive()) {
            userId = remoteUserMapper.getRemoteUser(httpRequest);
        }
        return userId;
    }

    public static User getUser(ServletContext sc, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        User user;
        block12: {
            HttpSession session;
            WebApplicationContext wc;
            String userId;
            block11: {
                userId = AuthenticationHelper.getRemoteUser(sc, httpRequest);
                wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)sc);
                session = httpRequest.getSession();
                user = null;
                User sessionUser = Application.getCurrentUser(session);
                if (sessionUser != null) {
                    AuthenticationService auth = (AuthenticationService)wc.getBean(AUTHENTICATION_SERVICE);
                    try {
                        auth.validate(sessionUser.getTicket());
                        if (sessionUser instanceof User) {
                            user = sessionUser;
                            AuthenticationHelper.setExternalAuth(session, userId != null);
                        } else {
                            user = AuthenticationHelper.setUser(sc, httpRequest, sessionUser.getUserName(), sessionUser.getTicket(), userId != null);
                        }
                    }
                    catch (AuthenticationException authErr) {
                        session.removeAttribute(AUTHENTICATION_USER);
                        if (Application.inPortalServer()) break block11;
                        session.invalidate();
                    }
                }
            }
            if (userId != null) {
                if (user != null && !user.getUserName().equals(userId)) {
                    session.removeAttribute(AUTHENTICATION_USER);
                    if (!Application.inPortalServer()) {
                        session.invalidate();
                    }
                    user = null;
                }
                if (user == null) {
                    AuthenticationComponent authenticationComponent = (AuthenticationComponent)wc.getBean(AUTHENTICATION_COMPONENT);
                    try {
                        authenticationComponent.setCurrentUser(userId);
                        AuthenticationService authenticationService = (AuthenticationService)wc.getBean(AUTHENTICATION_SERVICE);
                        user = AuthenticationHelper.setUser(sc, httpRequest, userId, authenticationService.getCurrentTicket(), true);
                    }
                    catch (AuthenticationException authErr) {
                        session.removeAttribute(AUTHENTICATION_USER);
                        if (Application.inPortalServer()) break block12;
                        session.invalidate();
                    }
                }
            }
        }
        return user;
    }

    public static void setUsernameCookie(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String username) {
        String encodedUsername;
        Cookie authCookie = AuthenticationHelper.getAuthCookie(httpRequest);
        try {
            encodedUsername = Base64.encodeBytes((byte[])username.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (authCookie == null) {
            authCookie = new Cookie(COOKIE_ALFUSER, encodedUsername);
        } else {
            authCookie.setValue(encodedUsername);
        }
        authCookie.setPath(httpRequest.getContextPath());
        authCookie.setMaxAge(604800);
        httpResponse.addCookie(authCookie);
    }

    public static Cookie getAuthCookie(HttpServletRequest httpRequest) {
        Cookie authCookie = null;
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!COOKIE_ALFUSER.equals(cookies[i].getName())) continue;
                authCookie = cookies[i];
                break;
            }
        }
        return authCookie;
    }

    public static String getAuthCookieValue(Cookie authCookie) {
        String authCookieValue = authCookie.getValue();
        if (authCookieValue == null) {
            return null;
        }
        try {
            return new String(Base64.decode((String)authCookieValue), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

