/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.web.util.HttpRangeProcessor;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.BaseServlet;
import org.apache.commons.logging.Log;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.surf.util.URLEncoder;

public abstract class BaseDownloadContentServlet
extends BaseServlet {
    private static final String HEADER_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final long serialVersionUID = -4558907921887235967L;
    private static final String POWER_POINT_DOCUMENT_MIMETYPE = "application/vnd.ms-powerpoint";
    private static final String POWER_POINT_2007_DOCUMENT_MIMETYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    private static final String HEADER_CONTENT_RANGE = "Content-Range";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_ACCEPT_RANGES = "Accept-Ranges";
    private static final String HEADER_RANGE = "Range";
    private static final String HEADER_ETAG = "ETag";
    private static final String HEADER_CACHE_CONTROL = "Cache-Control";
    private static final String HEADER_LAST_MODIFIED = "Last-Modified";
    private static final String HEADER_USER_AGENT = "User-Agent";
    private static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    protected static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    protected static final String MSG_ERROR_CONTENT_MISSING = "error_content_missing";
    protected static final String MSG_ERROR_NOT_FOUND = "error_not_found";
    protected static final String URL_DIRECT = "d";
    protected static final String URL_DIRECT_LONG = "direct";
    protected static final String URL_ATTACH = "a";
    protected static final String URL_ATTACH_LONG = "attach";
    protected static final String ARG_PROPERTY = "property";
    protected static final String ARG_PATH = "path";

    protected abstract Log getLogger();

    protected void processDownloadRequest(HttpServletRequest req, HttpServletResponse res, boolean allowLogIn, boolean transmitContent) throws ServletException, IOException {
        block40: {
            String filename;
            NodeRef nodeRef;
            Log logger = this.getLogger();
            String uri = req.getRequestURI();
            if (logger.isDebugEnabled()) {
                String queryString = req.getQueryString();
                logger.debug((Object)("Processing URL: " + uri + (queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
            }
            uri = uri.substring(req.getContextPath().length());
            StringTokenizer t = new StringTokenizer(uri, "/");
            int tokenCount = t.countTokens();
            t.nextToken();
            String attachToken = t.nextToken();
            boolean attachment = URL_ATTACH.equals(attachToken) || URL_ATTACH_LONG.equals(attachToken);
            ServiceRegistry serviceRegistry = BaseDownloadContentServlet.getServiceRegistry(this.getServletContext());
            String path = req.getParameter(ARG_PATH);
            if (path != null && path.length() != 0) {
                try {
                    BaseServlet.PathRefInfo pathInfo = BaseDownloadContentServlet.resolveNamePath(this.getServletContext(), path);
                    nodeRef = pathInfo.NodeRef;
                    filename = pathInfo.Filename;
                }
                catch (IllegalArgumentException e) {
                    Application.handleSystemError(this.getServletContext(), req, res, MSG_ERROR_NOT_FOUND, 404, logger);
                    return;
                }
            } else {
                if (tokenCount < 6) {
                    throw new IllegalArgumentException("Download URL did not contain all required args: " + uri);
                }
                StoreRef storeRef = new StoreRef(URLDecoder.decode((String)t.nextToken()), URLDecoder.decode((String)t.nextToken()));
                String id = URLDecoder.decode((String)t.nextToken());
                nodeRef = new NodeRef(storeRef, id);
                if (tokenCount > 6) {
                    ArrayList<String> paths = new ArrayList<String>(tokenCount - 5);
                    while (t.hasMoreTokens()) {
                        paths.add(URLDecoder.decode((String)t.nextToken()));
                    }
                    filename = (String)paths.get(paths.size() - 1);
                    try {
                        NodeRef parentRef = serviceRegistry.getNodeService().getPrimaryParent(nodeRef).getParentRef();
                        FileInfo fileInfo = serviceRegistry.getFileFolderService().resolveNamePath(parentRef, paths);
                        nodeRef = fileInfo.getNodeRef();
                    }
                    catch (FileNotFoundException e) {
                        Application.handleSystemError(this.getServletContext(), req, res, MSG_ERROR_NOT_FOUND, 404, logger);
                        return;
                    }
                } else {
                    filename = t.nextToken();
                }
            }
            QName propertyQName = ContentModel.PROP_CONTENT;
            String property = req.getParameter(ARG_PROPERTY);
            if (property != null && property.length() != 0) {
                propertyQName = QName.createQName((String)property);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found NodeRef: " + nodeRef));
                logger.debug((Object)("Will use filename: " + filename));
                logger.debug((Object)("For property: " + propertyQName));
                logger.debug((Object)("With attachment mode: " + attachment));
            }
            NodeService nodeService = serviceRegistry.getNodeService();
            ContentService contentService = serviceRegistry.getContentService();
            if (!nodeService.exists(nodeRef)) {
                Application.handleSystemError(this.getServletContext(), req, res, MSG_ERROR_NOT_FOUND, 404, logger);
                return;
            }
            try {
                if (!this.checkAccess(req, res, nodeRef, "ReadContent", allowLogIn)) {
                    return;
                }
                Date modified = (Date)nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED);
                if (modified != null) {
                    long modDate;
                    long modifiedSince = req.getDateHeader(HEADER_IF_MODIFIED_SINCE);
                    if (modifiedSince > 0L && (modDate = modified.getTime() / 1000L * 1000L) <= modifiedSince) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Returning 304 Not Modified.");
                        }
                        res.setStatus(304);
                        return;
                    }
                    res.setDateHeader(HEADER_LAST_MODIFIED, modified.getTime());
                    res.setHeader(HEADER_CACHE_CONTROL, "must-revalidate, max-age=0");
                    res.setHeader(HEADER_ETAG, "\"" + Long.toString(modified.getTime()) + "\"");
                }
                if (attachment) {
                    this.setHeaderContentDisposition(req, res, filename);
                }
                ContentReader reader = contentService.getReader(nodeRef, propertyQName);
                String mimetype = (reader = FileContentReader.getSafeContentReader((ContentReader)reader, (String)Application.getMessage(req.getSession(), MSG_ERROR_CONTENT_MISSING), (Object[])new Object[]{nodeRef, reader})).getMimetype();
                if (mimetype == null || mimetype.length() == 0) {
                    MimetypeService mimetypeMap = serviceRegistry.getMimetypeService();
                    mimetype = MIMETYPE_OCTET_STREAM;
                    int extIndex = filename.lastIndexOf(46);
                    if (extIndex != -1) {
                        String ext = filename.substring(extIndex + 1);
                        mimetype = mimetypeMap.getMimetype(ext);
                    }
                }
                if (!attachment && (mimetype.equals(POWER_POINT_2007_DOCUMENT_MIMETYPE) || mimetype.equals(POWER_POINT_DOCUMENT_MIMETYPE))) {
                    this.setHeaderContentDisposition(req, res, filename);
                }
                res.setHeader(HEADER_ACCEPT_RANGES, "bytes");
                if (transmitContent) {
                    try {
                        boolean processedRange = false;
                        String range = req.getHeader(HEADER_CONTENT_RANGE);
                        if (range == null) {
                            range = req.getHeader(HEADER_RANGE);
                        }
                        if (range != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Found content range header: " + range));
                            }
                            if (range.length() > 6) {
                                HttpRangeProcessor rangeProcessor = new HttpRangeProcessor(contentService);
                                processedRange = rangeProcessor.processRange(res, reader, range.substring(6), nodeRef, propertyQName, mimetype, req.getHeader(HEADER_USER_AGENT));
                            }
                        }
                        if (!processedRange) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Sending complete file content...");
                            }
                            res.setContentType(mimetype);
                            res.setCharacterEncoding(reader.getEncoding());
                            long size = reader.getSize();
                            res.setHeader(HEADER_CONTENT_RANGE, "bytes 0-" + Long.toString(size - 1L) + "/" + Long.toString(size));
                            res.setHeader(HEADER_CONTENT_LENGTH, Long.toString(size));
                            reader.getContent((OutputStream)res.getOutputStream());
                        }
                        break block40;
                    }
                    catch (SocketException e1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Client aborted stream read:\n\tnode: " + nodeRef + "\n\tcontent: " + reader));
                        }
                        break block40;
                    }
                    catch (ContentIOException e2) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Failed stream read:\n\tnode: " + nodeRef + " due to: " + e2.getMessage()));
                        }
                        break block40;
                    }
                    catch (Throwable err) {
                        if (err.getCause() instanceof SocketException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Client aborted stream read:\n\tnode: " + nodeRef + "\n\tcontent: " + reader));
                            }
                            break block40;
                        }
                        throw err;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"HEAD request processed - no content sent.");
                }
                res.getOutputStream().close();
            }
            catch (Throwable err) {
                throw new AlfrescoRuntimeException("Error during download content servlet processing: " + err.getMessage(), err);
            }
        }
    }

    private void setHeaderContentDisposition(HttpServletRequest req, HttpServletResponse res, String filename) {
        StringBuilder attachmentValue = new StringBuilder(128).append("attachment");
        String userAgent = req.getHeader(HEADER_USER_AGENT);
        if (userAgent != null && userAgent.toLowerCase().contains("msie")) {
            attachmentValue.append("; filename=\"").append(res.encodeURL(filename)).append("\"");
        }
        res.setHeader(HEADER_CONTENT_DISPOSITION, attachmentValue.toString());
    }

    protected static final String generateUrl(String pattern, NodeRef ref, String name) {
        return MessageFormat.format(pattern, ref.getStoreRef().getProtocol(), ref.getStoreRef().getIdentifier(), ref.getId(), URLEncoder.encode((String)name));
    }
}

