/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.webdav.auth.RemoteUserMapper;
import org.alfresco.service.cmr.security.PersonService;

public class DefaultRemoteUserMapper
implements RemoteUserMapper,
ActivateableBean {
    private String proxyUserName = "alfresco-system";
    private String proxyHeader = "X-Alfresco-Remote-User";
    private boolean isEnabled;
    private Pattern userIdPattern;
    private PersonService personService;

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName == null || proxyUserName.length() == 0 ? null : proxyUserName;
    }

    public void setProxyHeader(String proxyHeader) {
        this.proxyHeader = proxyHeader == null || proxyHeader.length() == 0 ? null : proxyHeader;
    }

    public void setActive(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setUserIdPattern(String userIdPattern) {
        this.userIdPattern = userIdPattern == null || userIdPattern.length() == 0 ? null : Pattern.compile(userIdPattern);
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public String getRemoteUser(HttpServletRequest request) {
        if (!this.isEnabled) {
            return null;
        }
        String remoteUserId = request.getRemoteUser();
        String headerUserId = this.extractUserFromProxyHeader(request);
        if (this.proxyUserName == null) {
            return this.normalizeUserId(headerUserId != null ? headerUserId : remoteUserId);
        }
        if (remoteUserId == null) {
            return null;
        }
        return this.normalizeUserId(remoteUserId.equals(this.proxyUserName) ? headerUserId : remoteUserId);
    }

    private String normalizeUserId(final String userId) {
        if (userId == null) {
            return null;
        }
        String normalized = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return DefaultRemoteUserMapper.this.personService.getUserIdentifier(userId);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return normalized == null ? userId : normalized;
    }

    public boolean isActive() {
        return this.isEnabled;
    }

    private String extractUserFromProxyHeader(HttpServletRequest request) {
        if (this.proxyHeader == null) {
            return null;
        }
        String userId = request.getHeader(this.proxyHeader);
        if (userId == null) {
            return null;
        }
        if (this.userIdPattern == null) {
            userId = userId.trim();
        } else {
            Matcher matcher = this.userIdPattern.matcher(userId);
            if (matcher.matches()) {
                userId = matcher.group(1).trim();
            } else {
                return null;
            }
        }
        return userId.length() == 0 ? null : userId;
    }
}

