/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.BaseDownloadContentServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadContentServlet
extends BaseDownloadContentServlet {
    private static final long serialVersionUID = -576405943603122206L;
    private static Log logger = LogFactory.getLog(DownloadContentServlet.class);
    private static final String DOWNLOAD_URL = "/d/a/{0}/{1}/{2}/{3}";
    private static final String BROWSER_URL = "/d/d/{0}/{1}/{2}/{3}";

    @Override
    protected Log getLogger() {
        return logger;
    }

    protected void doHead(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        AuthenticationStatus status;
        if (logger.isDebugEnabled()) {
            String queryString = req.getQueryString();
            logger.debug((Object)("Authenticating (HEAD) request to URL: " + req.getRequestURI() + (queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
        }
        if ((status = this.servletAuthenticate(req, res)) == AuthenticationStatus.Failure) {
            return;
        }
        ServiceRegistry serviceRegistry = DownloadContentServlet.getServiceRegistry(this.getServletContext());
        TransactionService transactionService = serviceRegistry.getTransactionService();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> processCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                DownloadContentServlet.this.processDownloadRequest(req, res, true, false);
                return null;
            }
        };
        transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)processCallback, true);
    }

    protected void doGet(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        AuthenticationStatus status;
        if (logger.isDebugEnabled()) {
            String queryString = req.getQueryString();
            logger.debug((Object)("Authenticating (GET) request to URL: " + req.getRequestURI() + (queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
        }
        if ((status = this.servletAuthenticate(req, res)) == AuthenticationStatus.Failure) {
            return;
        }
        ServiceRegistry serviceRegistry = DownloadContentServlet.getServiceRegistry(this.getServletContext());
        TransactionService transactionService = serviceRegistry.getTransactionService();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> processCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                DownloadContentServlet.this.processDownloadRequest(req, res, true, true);
                return null;
            }
        };
        transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)processCallback, true);
    }

    public static final String generateDownloadURL(NodeRef ref, String name) {
        return DownloadContentServlet.generateUrl(DOWNLOAD_URL, ref, name);
    }

    public static final String generateBrowserURL(NodeRef ref, String name) {
        return DownloadContentServlet.generateUrl(BROWSER_URL, ref, name);
    }
}

