/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.extensions.surf.util.I18NUtil;

public class GlobalLocalizationFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        I18NUtil.setContentLocale(null);
        this.setLanguageFromRequestHeader((HttpServletRequest)request);
        chain.doFilter(request, (ServletResponse)new HttpServletResponseWrapper((HttpServletResponse)response){

            public void setContentType(String type) {
                super.setContentType(type);
                int startIndex = type.indexOf(59) + 1;
                int length = type.length();
                while (startIndex != 0 && startIndex < length) {
                    String name;
                    String param;
                    int sepIndex;
                    int endIndex = type.indexOf(59, startIndex);
                    if (endIndex == -1) {
                        endIndex = length;
                    }
                    if ((sepIndex = (param = type.substring(startIndex, endIndex)).indexOf(61)) != -1 && (name = param.substring(0, sepIndex).trim()).equalsIgnoreCase("charset")) {
                        String charset = param.substring(sepIndex + 1).trim();
                        if (null != charset && (charset.startsWith("\"") && charset.endsWith("\"") || charset.startsWith("'") && charset.endsWith("'"))) {
                            charset = charset.substring(1, charset.length() - 1);
                        }
                        this.setCharacterEncoding(charset);
                        break;
                    }
                    startIndex = endIndex + 1;
                }
            }
        });
    }

    public void setLanguageFromRequestHeader(HttpServletRequest req) {
        Locale locale = null;
        String acceptLang = req.getHeader("Accept-Language");
        if (acceptLang != null && acceptLang.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(acceptLang, ",; ");
            String language = tokenizer.nextToken().replace('-', '_');
            locale = I18NUtil.parseLocale((String)language);
            I18NUtil.setLocale((Locale)locale);
        } else {
            I18NUtil.setLocale((Locale)Locale.getDefault());
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

