/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.web.app.servlet.BaseTemplateContentServlet;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.ui.repo.component.template.DefaultModelHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GuestTemplateContentServlet
extends BaseTemplateContentServlet {
    private static final long serialVersionUID = -2510767849932627519L;
    private static final Log logger = LogFactory.getLog(GuestTemplateContentServlet.class);
    private static final String DEFAULT_URL = "/guestTemplate/{0}/{1}/{2}";
    private static final String TEMPLATE_URL = "/guestTemplate/{0}/{1}/{2}/{3}/{4}/{5}";

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected Map<String, Object> buildModel(ServiceRegistry services, HttpServletRequest req, NodeRef templateRef) {
        MutableAuthenticationService auth = services.getAuthenticationService();
        PersonService personService = services.getPersonService();
        NodeService nodeService = services.getNodeService();
        NodeRef guestRef = personService.getPerson(AuthenticationUtil.getGuestUserName());
        User guestUser = new User(AuthenticationUtil.getGuestUserName(), auth.getCurrentTicket(), guestRef);
        NodeRef guestHomeRef = (NodeRef)nodeService.getProperty(guestRef, ContentModel.PROP_HOMEFOLDER);
        if (!nodeService.exists(guestHomeRef)) {
            throw new InvalidNodeRefException(guestHomeRef);
        }
        guestUser.setHomeSpaceId(guestHomeRef.getId());
        return DefaultModelHelper.buildDefaultModel(services, guestUser, templateRef, this.imageResolver);
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            String queryString = req.getQueryString();
            logger.debug((Object)("Setting up guest access to URL: " + req.getRequestURI() + (queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
        }
        TemplateContentWork tcw = new TemplateContentWork(req, res);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)tcw, (String)AuthenticationUtil.getGuestUserName());
    }

    public static final String generateURL(NodeRef nodeRef, NodeRef templateRef) {
        if (templateRef == null) {
            return MessageFormat.format(DEFAULT_URL, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId());
        }
        return MessageFormat.format(TEMPLATE_URL, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId(), templateRef.getStoreRef().getProtocol(), templateRef.getStoreRef().getIdentifier(), templateRef.getId());
    }

    public class TemplateContentWork
    implements AuthenticationUtil.RunAsWork<Object> {
        private HttpServletRequest req = null;
        private HttpServletResponse res = null;

        public TemplateContentWork(HttpServletRequest req, HttpServletResponse res) {
            this.req = req;
            this.res = res;
        }

        public Object doWork() throws Exception {
            GuestTemplateContentServlet.this.processTemplateRequest(this.req, this.res, false);
            return null;
        }
    }
}

