/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.AuthenticationHelper;
import org.alfresco.web.bean.repository.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HTTPRequestAuthenticationFilter
implements Filter {
    private static Log logger = LogFactory.getLog(HTTPRequestAuthenticationFilter.class);
    private ServletContext context;
    private String loginPage;
    private AuthenticationComponent authComponent;
    private AuthenticationService authenticationService;
    private String httpServletRequestAuthHeaderName;
    private String authPatternString = null;
    private Pattern authPattern = null;

    public void destroy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest sreq, ServletResponse sresp, FilterChain chain) throws IOException, ServletException {
        String userName;
        HttpServletResponse resp;
        HttpServletRequest req;
        block19: {
            User user;
            block18: {
                req = (HttpServletRequest)sreq;
                resp = (HttpServletResponse)sresp;
                String authHdr = req.getHeader(this.httpServletRequestAuthHeaderName);
                if (logger.isDebugEnabled()) {
                    if (authHdr == null) {
                        logger.debug((Object)("Header not found: " + this.httpServletRequestAuthHeaderName));
                    } else {
                        logger.debug((Object)("Header is <" + authHdr + ">"));
                    }
                }
                if (authHdr == null || authHdr.length() < 1) {
                    resp.sendRedirect(req.getContextPath() + "/jsp/noaccess.jsp");
                    return;
                }
                userName = "";
                if (this.authPattern != null) {
                    Matcher matcher = this.authPattern.matcher(authHdr);
                    if (matcher.matches()) {
                        userName = matcher.group();
                        if (userName == null || userName.length() < 1) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Extracted null or empty user name from pattern " + this.authPatternString + " against " + authHdr));
                            }
                            resp.sendRedirect(req.getContextPath() + "/jsp/noaccess.jsp");
                            return;
                        }
                        break block18;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("no pattern match for " + this.authPatternString + " against " + authHdr));
                        }
                        resp.sendRedirect(req.getContextPath() + "/jsp/noaccess.jsp");
                        return;
                    }
                }
                userName = authHdr;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("User = " + userName));
            }
            if ((user = AuthenticationHelper.getUser(this.context, req, resp)) != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("User " + user.getUserName() + " validate ticket"));
                    }
                    if (user.getUserName().equals(userName)) {
                        this.authComponent.clearCurrentSecurityContext();
                        this.authComponent.setCurrentUser(user.getUserName());
                        AuthenticationHelper.setupThread(this.context, req, resp, true);
                        chain.doFilter(sreq, sresp);
                        return;
                    }
                    this.setAuthenticatedUser(req, resp, userName);
                }
                catch (AuthenticationException ex) {
                    if (!logger.isErrorEnabled()) break block19;
                    logger.error((Object)("Failed to validate user " + user.getUserName()), (Throwable)ex);
                }
            }
        }
        this.setAuthenticatedUser(req, resp, userName);
        if (!req.getRequestURI().endsWith(this.getLoginPage())) {
            chain.doFilter(sreq, sresp);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Login page requested, chaining ...");
        }
        resp.sendRedirect(req.getContextPath() + "/faces" + "/jsp/browse/browse.jsp");
    }

    private void setAuthenticatedUser(HttpServletRequest req, HttpServletResponse res, String userName) {
        this.authComponent.clearCurrentSecurityContext();
        this.authComponent.setCurrentUser(userName);
        AuthenticationHelper.setUser(this.context, req, userName, this.authenticationService.getCurrentTicket(), true);
        AuthenticationHelper.setupThread(this.context, req, res, true);
    }

    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.context);
        this.authComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationService = (AuthenticationService)ctx.getBean("AuthenticationService");
        this.httpServletRequestAuthHeaderName = config.getInitParameter("httpServletRequestAuthHeaderName");
        if (this.httpServletRequestAuthHeaderName == null) {
            this.httpServletRequestAuthHeaderName = "x-user";
        }
        this.authPatternString = config.getInitParameter("authPatternString");
        if (this.authPatternString != null) {
            try {
                this.authPattern = Pattern.compile(this.authPatternString);
            }
            catch (PatternSyntaxException e) {
                logger.warn((Object)("Invalid pattern: " + this.authPatternString), (Throwable)e);
                this.authPattern = null;
            }
        }
    }

    private String getLoginPage() {
        if (this.loginPage == null) {
            this.loginPage = Application.getLoginPage(this.context);
        }
        return this.loginPage;
    }
}

