/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.webdav.auth.BaseNTLMAuthenticationFilter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.AuthenticationHelper;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.repository.PreferencesService;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.config.ClientConfigElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigService;

public class NTLMAuthenticationFilter
extends BaseNTLMAuthenticationFilter {
    private static Log logger = LogFactory.getLog(NTLMAuthenticationFilter.class);
    protected ConfigService m_configService;

    public void setConfigService(ConfigService configService) {
        this.m_configService = configService;
    }

    protected void init() throws ServletException {
        super.init();
        ClientConfigElement clientConfig = (ClientConfigElement)this.m_configService.getGlobalConfig().getConfigElement("client");
        if (clientConfig != null) {
            this.setLoginPage(clientConfig.getLoginPage());
        }
        this.setUserAttributeName("_alfAuthTicket");
    }

    protected SessionUser createUserObject(String userName, String ticket, NodeRef personNode, NodeRef homeSpaceRef) {
        User user = new User(userName, ticket, personNode);
        user.setHomeSpaceId(homeSpaceRef.getId());
        return user;
    }

    protected void onValidate(ServletContext sc, HttpServletRequest req, HttpServletResponse res) {
        AuthenticationHelper.setupThread(sc, req, res, !req.getServletPath().equals("/wcs") && !req.getServletPath().equals("/wcservice"));
    }

    protected boolean onLoginComplete(ServletContext sc, HttpServletRequest req, HttpServletResponse res, boolean userInit) throws IOException {
        String requestURI = req.getRequestURI();
        if (requestURI.startsWith(req.getContextPath() + "/faces") && (userInit || requestURI.endsWith(this.getLoginPage()))) {
            if (logger.isDebugEnabled() && requestURI.endsWith(this.getLoginPage())) {
                logger.debug((Object)"Login page requested - redirecting to initially configured page");
            }
            if (logger.isDebugEnabled() && userInit) {
                logger.debug((Object)"Session reinitialised - redirecting to initially configured page");
            }
            FacesContext fc = FacesHelper.getFacesContext((ServletRequest)req, (ServletResponse)res, sc);
            ConfigService configService = Application.getConfigService(fc);
            ClientConfigElement configElement = (ClientConfigElement)configService.getGlobalConfig().getConfigElement("client");
            String location = configElement.getInitialLocation();
            String preference = (String)((Object)PreferencesService.getPreferences(fc).getValue("start-location"));
            if (preference != null) {
                location = preference;
            }
            if ("myalfresco".equals(location)) {
                NavigationBean navigationBean = (NavigationBean)FacesHelper.getManagedBean(fc, "NavigationBean");
                if (navigationBean != null) {
                    navigationBean.setLocation(null);
                    navigationBean.setToolbarLocation(null);
                }
                res.sendRedirect(req.getContextPath() + "/faces" + "/jsp/dashboards/container.jsp");
            } else {
                res.sendRedirect(req.getContextPath() + "/faces" + "/jsp/browse/browse.jsp");
            }
            return false;
        }
        return true;
    }

    protected final Log getLogger() {
        return logger;
    }
}

