/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.AuthenticationStatus;
import org.alfresco.web.app.servlet.BaseTemplateContentServlet;
import org.alfresco.web.ui.repo.component.template.DefaultModelHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TemplateContentServlet
extends BaseTemplateContentServlet {
    private static final long serialVersionUID = -2510767849932627519L;
    private static final Log logger = LogFactory.getLog(TemplateContentServlet.class);
    private static final String DEFAULT_URL = "/t/{0}/{1}/{2}";
    private static final String TEMPLATE_URL = "/t/{0}/{1}/{2}/{3}/{4}/{5}";

    @Override
    protected Log getLogger() {
        return logger;
    }

    @Override
    protected Map<String, Object> buildModel(ServiceRegistry services, HttpServletRequest req, NodeRef templateRef) {
        return DefaultModelHelper.buildDefaultModel(services, Application.getCurrentUser(req.getSession()), templateRef, this.imageResolver);
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        AuthenticationStatus status;
        if (logger.isDebugEnabled()) {
            String queryString = req.getQueryString();
            logger.debug((Object)("Authenticating request to URL: " + req.getRequestURI() + (queryString != null && queryString.length() > 0 ? "?" + queryString : "")));
        }
        if ((status = this.servletAuthenticate(req, res)) == AuthenticationStatus.Failure) {
            return;
        }
        TemplateContentServlet.setNoCacheHeaders(res);
        this.processTemplateRequest(req, res, true);
    }

    public static final String generateURL(NodeRef nodeRef, NodeRef templateRef) {
        if (templateRef == null) {
            return MessageFormat.format(DEFAULT_URL, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId());
        }
        return MessageFormat.format(TEMPLATE_URL, nodeRef.getStoreRef().getProtocol(), nodeRef.getStoreRef().getIdentifier(), nodeRef.getId(), templateRef.getStoreRef().getProtocol(), templateRef.getStoreRef().getIdentifier(), templateRef.getId());
    }
}

