/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.repo.SessionUser;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.web.filter.beans.DependencyInjectedFilter;
import org.alfresco.repo.webdav.auth.BaseAuthenticationFilter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.servlet.AuthenticationHelper;
import org.alfresco.web.bean.repository.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.Match;
import org.springframework.extensions.webscripts.RuntimeContainer;

public class WebScriptSSOAuthenticationFilter
extends BaseAuthenticationFilter
implements DependencyInjectedFilter,
ActivateableBean {
    private static final String API_LOGIN = "/api/login";
    private static final Log logger = LogFactory.getLog(WebScriptSSOAuthenticationFilter.class);
    private RuntimeContainer container;
    private boolean isActive = true;

    public WebScriptSSOAuthenticationFilter() {
        this.setUserAttributeName("_alfAuthTicket");
    }

    public void setContainer(RuntimeContainer container) {
        this.container = container;
    }

    public final void setActive(boolean active) {
        this.isActive = active;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    public void doFilter(ServletContext context, ServletRequest sreq, ServletResponse sresp, FilterChain chain) throws IOException, ServletException {
        String script;
        Match match;
        HttpServletRequest req = (HttpServletRequest)sreq;
        HttpServletResponse res = (HttpServletResponse)sresp;
        String requestURI = req.getRequestURI();
        String pathInfo = requestURI.substring((req.getContextPath() + req.getServletPath()).length());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Processing request: " + requestURI + " SID:" + (req.getSession(false) != null ? req.getSession().getId() : null)));
        }
        if ((match = this.container.getRegistry().findWebScript(req.getMethod(), URLDecoder.decode((String)pathInfo))) != null && match.getWebScript() != null && Description.RequiredAuthentication.none == match.getWebScript().getDescription().getRequiredAuthentication()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)"Found webscript with no authentication - set NO_AUTH_REQUIRED flag.");
            }
            req.setAttribute("alfNoAuthRequired", (Object)Boolean.TRUE);
        }
        if ((script = req.getPathInfo()) != null && script.equals(API_LOGIN) && req.getMethod().equalsIgnoreCase("POST")) {
            if (this.handleLoginForm(req, res)) {
                // empty if block
            }
            AuthenticationHelper.setupThread(context, req, res, false);
        } else {
            chain.doFilter(sreq, sresp);
        }
    }

    protected SessionUser createUserObject(String userName, String ticket, NodeRef personNode, NodeRef homeSpaceRef) {
        User user = new User(userName, ticket, personNode);
        user.setHomeSpaceId(homeSpaceRef.getId());
        return user;
    }

    protected Log getLogger() {
        return logger;
    }
}

