/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class WorkflowDefinitionImageServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        StringTokenizer t = new StringTokenizer(uri = uri.substring(request.getContextPath().length()), "/");
        if (t.countTokens() != 2) {
            throw new WorkflowException("Workflow Definition Image servlet does not contain workflow definition id : " + uri);
        }
        t.nextToken();
        String workflowDefinitionId = t.nextToken();
        WebApplicationContext wc = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        WorkflowService workflowService = (WorkflowService)wc.getBean(ServiceRegistry.WORKFLOW_SERVICE.getLocalName());
        byte[] definitionImage = workflowService.getDefinitionImage(workflowDefinitionId);
        ServletOutputStream out = response.getOutputStream();
        out.write(definitionImage);
        out.flush();
    }
}

