/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.ajax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.ajax.BaseAjaxCommand;
import org.alfresco.web.bean.repository.Repository;

public class InvokeCommand
extends BaseAjaxCommand {
    @Override
    public void execute(FacesContext facesContext, String expression, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResponseWriter writer = null;
        try {
            Method method;
            String responseMimetype;
            int indexOfDot = expression.indexOf(46);
            String variableName = expression.substring(0, indexOfDot);
            String methodName = expression.substring(indexOfDot + 1);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking method represented by " + expression + " on variable " + variableName + " with method " + methodName));
            }
            Object bean = null;
            if (Application.inPortalServer()) {
                String beanNameSuffix = "?" + variableName;
                Enumeration enumNames = request.getSession().getAttributeNames();
                while (enumNames.hasMoreElements()) {
                    String name = (String)enumNames.nextElement();
                    if (!name.endsWith(beanNameSuffix)) continue;
                    bean = request.getSession().getAttribute(name);
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Found bean " + bean + " in the session"));
                    break;
                }
            }
            if (bean == null) {
                VariableResolver vr = facesContext.getApplication().getVariableResolver();
                bean = vr.resolveVariable(facesContext, variableName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created bean " + bean + " via the variable resolver"));
                }
            }
            String string = responseMimetype = (method = bean.getClass().getMethod(methodName, new Class[0])).isAnnotationPresent(ResponseMimetype.class) ? method.getAnnotation(ResponseMimetype.class).value() : "text/xml";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("invoking method " + method + " with repsonse mimetype  " + responseMimetype));
            }
            writer = this.setupResponseWriter(responseMimetype, response, facesContext);
            RetryingTransactionHelper txnHelper = Repository.getRetryingTransactionHelper(FacesContext.getCurrentInstance());
            final Object beanFinal = bean;
            RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    try {
                        method.invoke(beanFinal, new Object[0]);
                        return null;
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() != null) {
                            throw e.getCause();
                        }
                        throw e;
                    }
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        catch (EvaluationException e) {
            Throwable err = e.getCause();
            if (err == null) {
                logger.error((Object)("Failed to execute method " + expression + ": " + e.getMessage()), (Throwable)e);
                throw e;
            }
            logger.error((Object)("Failed to execute method " + expression + ": " + err.getMessage()), err);
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            throw new AlfrescoRuntimeException("Failed to execute method " + expression + ": " + err.getMessage(), err);
        }
        catch (RuntimeException err) {
            logger.error((Object)("Failed to execute method " + expression + ": " + err.getMessage()), (Throwable)err);
            throw err;
        }
        catch (Exception err) {
            logger.error((Object)("Failed to execute method " + expression + ": " + err.getMessage()), (Throwable)err);
            throw new AlfrescoRuntimeException("Failed to execute method " + expression + ": " + err.getMessage(), (Throwable)err);
        }
        writer.close();
    }

    private ResponseWriter setupResponseWriter(String mimetype, HttpServletResponse response, FacesContext facesContext) throws IOException {
        ServletOutputStream os = response.getOutputStream();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(facesContext, viewRoot.getRenderKitId());
        ResponseWriter writer = renderKit.createResponseWriter((Writer)new OutputStreamWriter((OutputStream)os, "UTF-8"), mimetype, "UTF-8");
        facesContext.setResponseWriter(writer);
        response.setContentType(mimetype);
        return writer;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ResponseMimetype {
        public String value() default "text/xml";
    }
}

