/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.util.Map;
import javax.servlet.ServletContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.web.app.servlet.command.CommandProcessor;
import org.alfresco.web.bean.repository.Repository;

public abstract class BaseNodeCommandProcessor
implements CommandProcessor {
    protected NodeRef targetRef;

    @Override
    public boolean validateArguments(ServletContext sc, String command, Map<String, String> args, String[] urlElements) {
        if (urlElements.length < 3) {
            throw new IllegalArgumentException("Not enough URL arguments passed to command servlet.");
        }
        StoreRef storeRef = new StoreRef(urlElements[0], urlElements[1]);
        this.targetRef = new NodeRef(storeRef, urlElements[2]);
        PermissionService permissionService = Repository.getServiceRegistry(sc).getPermissionService();
        return permissionService.hasPermission(this.targetRef, "Read") == AccessStatus.ALLOWED;
    }
}

