/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.util.Map;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.app.servlet.command.BaseUIActionCommand;
import org.alfresco.web.bean.BrowseBean;
import org.alfresco.web.bean.repository.Node;
import org.springframework.extensions.surf.util.ParameterCheck;

public class EditSpaceCommand
extends BaseUIActionCommand {
    public static final String PROP_NODEREF = "noderef";
    private static final String[] PROPERTIES = new String[]{"ServletContext", "Request", "Response", "noderef"};

    @Override
    public Object execute(ServiceRegistry serviceRegistry, Map<String, Object> properties) {
        ServletContext sc = (ServletContext)properties.get("ServletContext");
        ServletRequest req = (ServletRequest)properties.get("Request");
        ServletResponse res = (ServletResponse)properties.get("Response");
        FacesContext fc = FacesHelper.getFacesContext(req, res, sc, "/jsp/close.jsp");
        BrowseBean browseBean = (BrowseBean)FacesHelper.getManagedBean(fc, "BrowseBean");
        String strNodeRef = (String)properties.get(PROP_NODEREF);
        ParameterCheck.mandatoryString((String)PROP_NODEREF, (String)strNodeRef);
        browseBean.setActionSpace(new Node(new NodeRef(strNodeRef)));
        NavigationHandler navigationHandler = fc.getApplication().getNavigationHandler();
        navigationHandler.handleNavigation(fc, null, "dialog:editSpace");
        String viewId = fc.getViewRoot().getViewId();
        try {
            sc.getRequestDispatcher("/faces" + viewId).forward(req, res);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Unable to forward to viewId: " + viewId, (Throwable)e);
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return PROPERTIES;
    }
}

