/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.servlet.BaseServlet;
import org.alfresco.web.app.servlet.command.Command;
import org.alfresco.web.app.servlet.command.CommandFactory;
import org.alfresco.web.app.servlet.command.CommandProcessor;
import org.alfresco.web.app.servlet.command.ExecuteScriptCommand;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.config.ClientConfigElement;
import org.springframework.extensions.config.ConfigService;

public final class ScriptCommandProcessor
implements CommandProcessor {
    private static final String ARG_SCRIPT_PATH = "scriptPath";
    private static final String ARG_CONTEXT_PATH = "contextPath";
    private NodeRef scriptRef;
    private NodeRef docRef;
    private Object result;

    @Override
    public boolean validateArguments(ServletContext sc, String command, Map<String, String> args, String[] urlElements) {
        boolean allowed = false;
        String scriptPath = args.get(ARG_SCRIPT_PATH);
        if (scriptPath != null) {
            this.scriptRef = BaseServlet.resolveNamePath((ServletContext)sc, (String)scriptPath).NodeRef;
            String docPath = args.get(ARG_CONTEXT_PATH);
            if (docPath != null) {
                this.docRef = BaseServlet.resolveNamePath((ServletContext)sc, (String)docPath).NodeRef;
            }
        } else {
            if (urlElements.length < 3) {
                throw new IllegalArgumentException("Not enough URL arguments passed to command servlet.");
            }
            StoreRef storeRef = new StoreRef(urlElements[0], urlElements[1]);
            this.scriptRef = new NodeRef(storeRef, urlElements[2]);
            if (urlElements.length >= 6) {
                storeRef = new StoreRef(urlElements[3], urlElements[4]);
                this.docRef = new NodeRef(storeRef, urlElements[5]);
            }
        }
        PermissionService ps = Repository.getServiceRegistry(sc).getPermissionService();
        boolean bl = allowed = ps.hasPermission(this.scriptRef, "Read") == AccessStatus.ALLOWED;
        if (this.docRef != null) {
            allowed &= ps.hasPermission(this.docRef, "Read") == AccessStatus.ALLOWED;
        }
        ConfigService configService = Application.getConfigService(sc);
        ClientConfigElement configElement = (ClientConfigElement)configService.getGlobalConfig().getConfigElement("client");
        boolean allowScriptExecute = configElement.getAllowUserScriptExecute();
        AuthorityService authService = Repository.getServiceRegistry(sc).getAuthorityService();
        return allowed &= allowScriptExecute || authService.isAdminAuthority(AuthenticationUtil.getFullyAuthenticatedUser());
    }

    @Override
    public void process(ServiceRegistry serviceRegistry, HttpServletRequest request, String command) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4, 1.0f);
        properties.put("script", this.scriptRef);
        properties.put("document", this.docRef);
        User user = Application.getCurrentUser(request.getSession());
        properties.put("person", user.getPerson());
        ScriptableHashMap args = new ScriptableHashMap();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            args.put(name, request.getParameter(name));
        }
        properties.put("args", args);
        Command cmd = CommandFactory.getInstance().createCommand(command);
        if (cmd == null) {
            throw new AlfrescoRuntimeException("Unregistered script command specified: " + command);
        }
        this.result = cmd.execute(serviceRegistry, properties);
    }

    @Override
    public void outputStatus(PrintWriter out) {
        out.write(this.result != null ? this.result.toString() : "Successfully executed script.");
    }

    static {
        CommandFactory.getInstance().registerCommand("execute", ExecuteScriptCommand.class);
    }
}

