/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.util.Map;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.app.servlet.command.BaseUIActionCommand;
import org.alfresco.web.bean.users.UsersDialog;
import org.springframework.extensions.surf.util.ParameterCheck;

public class UserProfileDialogCommand
extends BaseUIActionCommand {
    public static final String PROP_PERSONID = "id";
    private static final String[] PROPERTIES = new String[]{"ServletContext", "Request", "Response", "id"};

    @Override
    public Object execute(ServiceRegistry serviceRegistry, Map<String, Object> properties) {
        ServletContext sc = (ServletContext)properties.get("ServletContext");
        ServletRequest req = (ServletRequest)properties.get("Request");
        ServletResponse res = (ServletResponse)properties.get("Response");
        FacesContext fc = FacesHelper.getFacesContext(req, res, sc, "/jsp/close.jsp");
        UsersDialog dialog = (UsersDialog)FacesHelper.getManagedBean(fc, UsersDialog.BEAN_NAME);
        String personId = (String)properties.get(PROP_PERSONID);
        ParameterCheck.mandatoryString((String)PROP_PERSONID, (String)personId);
        dialog.setupUserAction(personId);
        NavigationHandler navigationHandler = fc.getApplication().getNavigationHandler();
        navigationHandler.handleNavigation(fc, null, "dialog:userProfile");
        String viewId = fc.getViewRoot().getViewId();
        try {
            sc.getRequestDispatcher("/faces" + viewId).forward(req, res);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Unable to forward to viewId: " + viewId, (Throwable)e);
        }
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        return PROPERTIES;
    }
}

