/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.app.servlet.command;

import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.web.app.servlet.command.ApproveWorkflowCommand;
import org.alfresco.web.app.servlet.command.BaseNodeCommandProcessor;
import org.alfresco.web.app.servlet.command.Command;
import org.alfresco.web.app.servlet.command.CommandFactory;
import org.alfresco.web.app.servlet.command.RejectWorkflowCommand;
import org.alfresco.web.ui.common.Utils;

public final class WorkflowCommandProcessor
extends BaseNodeCommandProcessor {
    private String command;

    @Override
    public void process(ServiceRegistry serviceRegistry, HttpServletRequest request, String command) {
        HashMap<String, Object> properties = new HashMap<String, Object>(1, 1.0f);
        properties.put("target", this.targetRef);
        Command cmd = CommandFactory.getInstance().createCommand(command);
        if (cmd == null) {
            throw new AlfrescoRuntimeException("Unregistered workflow command specified: " + command);
        }
        cmd.execute(serviceRegistry, properties);
        this.command = command;
    }

    @Override
    public void outputStatus(PrintWriter out) {
        out.print("Workflow command: '");
        out.print(Utils.encode((String)this.command));
        out.print("' executed against node: ");
        out.println(Utils.encode((String)this.targetRef.toString()));
    }

    static {
        CommandFactory.getInstance().registerCommand("approve", ApproveWorkflowCommand.class);
        CommandFactory.getInstance().registerCommand("reject", RejectWorkflowCommand.class);
    }
}

