/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import javax.faces.context.FacesContext;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.web.app.Application;
import org.alfresco.web.bean.dialog.BaseDialogBean;
import org.alfresco.web.bean.repository.Repository;

public class AboutBean
extends BaseDialogBean {
    private static final long serialVersionUID = -3777479360531145878L;
    private static final String MSG_VERSION = "version";
    private static final String MSG_CLOSE = "close";
    private transient DescriptorService descriptorService;

    public String getVersion() {
        return this.getDescriptorService().getServerDescriptor().getVersion();
    }

    public String getEdition() {
        return this.getDescriptorService().getServerDescriptor().getEdition();
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    @Override
    protected String finishImpl(FacesContext context, String outcome) throws Exception {
        return null;
    }

    @Override
    public String getContainerDescription() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_VERSION) + " :" + this.getEdition() + " - v" + this.getVersion();
    }

    DescriptorService getDescriptorService() {
        if (this.descriptorService == null) {
            this.descriptorService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDescriptorService();
        }
        return this.descriptorService;
    }

    @Override
    public String getCancelButtonLabel() {
        return Application.getMessage(FacesContext.getCurrentInstance(), MSG_CLOSE);
    }

    @Override
    protected String getDefaultCancelOutcome() {
        return "dialog:close:browse";
    }
}

