/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.transaction.UserTransaction;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.FileFilterMode;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.IContextListener;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.app.servlet.DownloadContentServlet;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.NavigationBean;
import org.alfresco.web.bean.NodeEventListener;
import org.alfresco.web.bean.content.DocumentDetailsDialog;
import org.alfresco.web.bean.ml.MultilingualManageDialog;
import org.alfresco.web.bean.repository.MapNode;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.NodePropertyResolver;
import org.alfresco.web.bean.repository.QNameNodeMap;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.search.SearchContext;
import org.alfresco.web.bean.users.UserPreferencesBean;
import org.alfresco.web.config.ViewsConfigElement;
import org.alfresco.web.ui.common.PanelGenerator;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.IBreadcrumbHandler;
import org.alfresco.web.ui.common.component.UIActionLink;
import org.alfresco.web.ui.common.component.UIBreadcrumb;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.common.component.UIPanel;
import org.alfresco.web.ui.common.component.UIStatusMessage;
import org.alfresco.web.ui.common.component.data.UIRichList;
import org.alfresco.web.ui.repo.component.IRepoBreadcrumbHandler;
import org.alfresco.web.ui.repo.component.UINodeDescendants;
import org.alfresco.web.ui.repo.component.UINodePath;
import org.alfresco.web.ui.repo.component.UISimpleSearch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.Config;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigService;

public class BrowseBean
implements IContextListener,
Serializable {
    private static final long serialVersionUID = -3234262484615161360L;
    public static final String BEAN_NAME = "BrowseBean";
    public NodePropertyResolver resolverDownload = new NodePropertyResolver(){
        private static final long serialVersionUID = 4048859853585650378L;

        @Override
        public Object get(Node node) {
            return DownloadContentServlet.generateDownloadURL(node.getNodeRef(), node.getName());
        }
    };
    public NodePropertyResolver resolverUrl = new NodePropertyResolver(){
        private static final long serialVersionUID = -5264085143622470386L;

        @Override
        public Object get(Node node) {
            return DownloadContentServlet.generateBrowserURL(node.getNodeRef(), node.getName());
        }
    };
    public NodePropertyResolver resolverWebdavUrl = new NodePropertyResolver(){
        private static final long serialVersionUID = 9127234483419089006L;

        @Override
        public Object get(Node node) {
            return Utils.generateURL(FacesContext.getCurrentInstance(), node, Utils.URLMode.WEBDAV);
        }
    };
    public NodePropertyResolver resolverCifsPath = new NodePropertyResolver(){
        private static final long serialVersionUID = -5804924617772163104L;

        @Override
        public Object get(Node node) {
            return Utils.generateURL(FacesContext.getCurrentInstance(), node, Utils.URLMode.CIFS);
        }
    };
    public NodePropertyResolver resolverLinkDownload = new NodePropertyResolver(){
        private static final long serialVersionUID = 7208696954599958859L;

        @Override
        public Object get(Node node) {
            NodeRef destRef = (NodeRef)node.getProperties().get(ContentModel.PROP_LINK_DESTINATION);
            if (BrowseBean.this.getNodeService().exists(destRef)) {
                String destName = Repository.getNameForNode(BrowseBean.this.getNodeService(), destRef);
                return DownloadContentServlet.generateDownloadURL(destRef, destName);
            }
            return "#";
        }
    };
    public NodePropertyResolver resolverLinkUrl = new NodePropertyResolver(){
        private static final long serialVersionUID = -1280702397805414147L;

        @Override
        public Object get(Node node) {
            NodeRef destRef = (NodeRef)node.getProperties().get(ContentModel.PROP_LINK_DESTINATION);
            if (BrowseBean.this.getNodeService().exists(destRef)) {
                String destName = Repository.getNameForNode(BrowseBean.this.getNodeService(), destRef);
                return DownloadContentServlet.generateBrowserURL(destRef, destName);
            }
            return "#";
        }
    };
    public NodePropertyResolver resolverLinkWebdavUrl = new NodePropertyResolver(){
        private static final long serialVersionUID = -3097558079118837397L;

        @Override
        public Object get(Node node) {
            NodeRef destRef = (NodeRef)node.getProperties().get(ContentModel.PROP_LINK_DESTINATION);
            if (BrowseBean.this.getNodeService().exists(destRef)) {
                return Utils.generateURL(FacesContext.getCurrentInstance(), new Node(destRef), Utils.URLMode.WEBDAV);
            }
            return "#";
        }
    };
    public NodePropertyResolver resolverLinkCifsPath = new NodePropertyResolver(){
        private static final long serialVersionUID = 673020173327603487L;

        @Override
        public Object get(Node node) {
            NodeRef destRef = (NodeRef)node.getProperties().get(ContentModel.PROP_LINK_DESTINATION);
            if (BrowseBean.this.getNodeService().exists(destRef)) {
                return Utils.generateURL(FacesContext.getCurrentInstance(), new Node(destRef), Utils.URLMode.CIFS);
            }
            return "#";
        }
    };
    public NodePropertyResolver resolverFileType16 = new NodePropertyResolver(){
        private static final long serialVersionUID = -2690520488415178029L;

        @Override
        public Object get(Node node) {
            return FileTypeImageUtils.getFileTypeImage((String)node.getName(), (boolean)true);
        }
    };
    public NodePropertyResolver resolverFileType32 = new NodePropertyResolver(){
        private static final long serialVersionUID = 1991254398502584389L;

        @Override
        public Object get(Node node) {
            return FileTypeImageUtils.getFileTypeImage((String)node.getName(), (boolean)false);
        }
    };
    public NodePropertyResolver resolverPath = new NodePropertyResolver(){
        private static final long serialVersionUID = 8008094870888545035L;

        @Override
        public Object get(Node node) {
            return node.getNodePath();
        }
    };
    public NodePropertyResolver resolverDisplayPath = new NodePropertyResolver(){
        private static final long serialVersionUID = -918422848579179425L;

        @Override
        public Object get(Node node) {
            return Repository.getDisplayPath(node.getNodePath());
        }
    };
    public NodePropertyResolver resolverSpaceIcon = new NodePropertyResolver(){
        private static final long serialVersionUID = -5644418026591098018L;

        @Override
        public Object get(Node node) {
            QNameNodeMap props = (QNameNodeMap)node.getProperties();
            String icon = (String)props.getRaw("app:icon");
            return icon != null ? icon : "space-icon-default";
        }
    };
    public NodePropertyResolver resolverSmallIcon = new NodePropertyResolver(){
        private static final long serialVersionUID = -150483121767183580L;

        @Override
        public Object get(Node node) {
            QNameNodeMap props = (QNameNodeMap)node.getProperties();
            String icon = (String)props.getRaw("app:icon");
            return icon != null ? icon + "-16" : BrowseBean.SPACE_SMALL_DEFAULT;
        }
    };
    public NodePropertyResolver resolverMimetype = new NodePropertyResolver(){
        private static final long serialVersionUID = -8864267975247235172L;

        @Override
        public Object get(Node node) {
            ContentData content = (ContentData)node.getProperties().get(ContentModel.PROP_CONTENT);
            return content != null ? content.getMimetype() : null;
        }
    };
    public NodePropertyResolver resolverEncoding = new NodePropertyResolver(){
        private static final long serialVersionUID = -1130974681844152101L;

        @Override
        public Object get(Node node) {
            ContentData content = (ContentData)node.getProperties().get(ContentModel.PROP_CONTENT);
            return content != null ? content.getEncoding() : null;
        }
    };
    public NodePropertyResolver resolverSize = new NodePropertyResolver(){
        private static final long serialVersionUID = 1273541660444385276L;

        @Override
        public Object get(Node node) {
            ContentData content = (ContentData)node.getProperties().get(ContentModel.PROP_CONTENT);
            return content != null ? new Long(content.getSize()) : 0L;
        }
    };
    public NodePropertyResolver resolverLang = new NodePropertyResolver(){
        private static final long serialVersionUID = 5412446489528560367L;

        @Override
        public Object get(Node node) {
            String lang = null;
            if (node.getAspects().contains(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT)) {
                Locale locale = null;
                if (node.hasAspect(ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION)) {
                    NodeRef pivot = BrowseBean.this.getMultilingualContentService().getPivotTranslation(node.getNodeRef());
                    locale = (Locale)BrowseBean.this.getNodeService().getProperty(pivot, ContentModel.PROP_LOCALE);
                } else {
                    locale = (Locale)node.getProperties().get(ContentModel.PROP_LOCALE);
                }
                String userLang = BrowseBean.this.userPreferencesBean.getContentFilterLanguage();
                String nodeLang = locale.getLanguage();
                if (nodeLang == null) {
                    lang = nodeLang;
                } else if (!nodeLang.equalsIgnoreCase(userLang)) {
                    lang = nodeLang;
                }
            }
            return lang;
        }
    };
    private static Log logger = LogFactory.getLog(BrowseBean.class);
    public static final String BROWSE_VIEW_ID = "/jsp/browse/browse.jsp";
    public static final String CATEGORY_VIEW_ID = "/jsp/browse/category-browse.jsp";
    public static final String SPACE_SMALL_DEFAULT = "space_small";
    private static final String VIEWMODE_DASHBOARD = "dashboard";
    private static final String PAGE_NAME_BROWSE = "browse";
    private static final String MSG_DELETE_COMPANYROOT = "delete_companyroot_confirm";
    public static final String MSG_SEARCH_MINIMUM = "search_minimum";
    private static final String MSG_CANNOT_DELETE_NODE_HAS_WORKING_COPY = "cannot_delete_node_has_working_copy";
    private transient NodeService nodeService;
    private transient CheckOutCheckInService checkOutCheckInService;
    private transient SearchService searchService;
    private transient LockService lockService;
    protected NavigationBean navigator;
    protected UserPreferencesBean userPreferencesBean;
    private transient DictionaryService dictionaryService;
    private transient FileFolderService fileFolderService;
    private transient MultilingualContentService multilingualContentService;
    protected ViewsConfigElement viewsConfig = null;
    protected Set<NodeEventListener> nodeEventListeners = null;
    private Map<String, Boolean> panels = new HashMap<String, Boolean>(4, 1.0f);
    protected UIRichList spacesRichList;
    protected UIRichList contentRichList;
    private UIStatusMessage statusMessage;
    protected List<Node> containerNodes = null;
    protected List<Node> contentNodes = null;
    protected List<Node> parentContainerNodes = null;
    protected Node actionSpace;
    protected Node document;
    private String deleteMessage;
    private String browseViewMode;
    private int pageSizeSpaces;
    private int pageSizeContent;
    private String pageSizeSpacesStr;
    private String pageSizeContentStr;
    private boolean dashboardView;
    private boolean externalForceRefresh = false;

    public BrowseBean() {
        UIContextService.getInstance(FacesContext.getCurrentInstance()).registerBean(this);
        this.initFromClientConfig();
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setCheckOutCheckInService(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    protected CheckOutCheckInService getCheckOutCheckInService() {
        if (this.checkOutCheckInService == null) {
            this.checkOutCheckInService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getCheckOutCheckInService();
        }
        return this.checkOutCheckInService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    protected SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public void setUserPreferencesBean(UserPreferencesBean userPreferencesBean) {
        this.userPreferencesBean = userPreferencesBean;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    protected LockService getLockService() {
        if (this.lockService == null) {
            this.lockService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getLockService();
        }
        return this.lockService;
    }

    public void setNavigator(NavigationBean navigator) {
        this.navigator = navigator;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected DictionaryService getDictionaryService() {
        if (this.dictionaryService == null) {
            this.dictionaryService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDictionaryService();
        }
        return this.dictionaryService;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    protected MultilingualContentService getMultilingualContentService() {
        if (this.multilingualContentService == null) {
            this.multilingualContentService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getMultilingualContentService();
        }
        return this.multilingualContentService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    protected FileFolderService getFileFolderService() {
        if (this.fileFolderService == null) {
            this.fileFolderService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getFileFolderService();
        }
        return this.fileFolderService;
    }

    public String getBrowseViewMode() {
        return this.browseViewMode;
    }

    public void setBrowseViewMode(String browseViewMode) {
        this.browseViewMode = browseViewMode;
    }

    public boolean isDashboardView() {
        return this.dashboardView;
    }

    public void setDashboardView(boolean dashboardView) {
        this.dashboardView = dashboardView;
        if (dashboardView) {
            FacesContext fc = FacesContext.getCurrentInstance();
            fc.getApplication().getNavigationHandler().handleNavigation(fc, null, VIEWMODE_DASHBOARD);
        }
    }

    public int getPageSizeContent() {
        return this.pageSizeContent;
    }

    public void setPageSizeContent(int pageSizeContent) {
        this.pageSizeContent = pageSizeContent;
        this.pageSizeContentStr = Integer.toString(pageSizeContent);
    }

    public int getPageSizeSpaces() {
        return this.pageSizeSpaces;
    }

    public void setPageSizeSpaces(int pageSizeSpaces) {
        this.pageSizeSpaces = pageSizeSpaces;
        this.pageSizeSpacesStr = Integer.toString(pageSizeSpaces);
    }

    public String getPageSizeContentStr() {
        return this.pageSizeContentStr;
    }

    public void setPageSizeContentStr(String pageSizeContentStr) {
        this.pageSizeContentStr = pageSizeContentStr;
    }

    public String getPageSizeSpacesStr() {
        return this.pageSizeSpacesStr;
    }

    public void setPageSizeSpacesStr(String pageSizeSpacesStr) {
        this.pageSizeSpacesStr = pageSizeSpacesStr;
    }

    public static int getMinimumSearchLength() {
        return Application.getClientConfig(FacesContext.getCurrentInstance()).getSearchMinimum();
    }

    public Map<String, Boolean> getPanels() {
        return this.panels;
    }

    public void setPanels(Map<String, Boolean> panels) {
        this.panels = panels;
    }

    public Node getActionSpace() {
        return this.actionSpace;
    }

    public void setActionSpace(Node actionSpace) {
        if (actionSpace != null) {
            for (NodeEventListener listener : this.getNodeEventListeners()) {
                listener.created(actionSpace, actionSpace.getType());
            }
        }
        this.actionSpace = actionSpace;
    }

    public Node getDocument() {
        return this.document;
    }

    public void setDocument(Node document) {
        if (document != null) {
            for (NodeEventListener listener : this.getNodeEventListeners()) {
                listener.created(document, document.getType());
            }
        }
        this.document = document;
    }

    public void setContentRichList(UIRichList contentRichList) {
        this.contentRichList = contentRichList;
        if (this.contentRichList != null) {
            this.contentRichList.setInitialSortColumn(this.viewsConfig.getDefaultSortColumn(PAGE_NAME_BROWSE));
            this.contentRichList.setInitialSortDescending(this.viewsConfig.hasDescendingSort(PAGE_NAME_BROWSE));
        }
        if (this.externalForceRefresh) {
            this.contentRichList.setValue(null);
            this.externalForceRefresh = false;
        }
    }

    public UIRichList getContentRichList() {
        return this.contentRichList;
    }

    public void setSpacesRichList(UIRichList spacesRichList) {
        this.spacesRichList = spacesRichList;
        if (this.spacesRichList != null) {
            this.spacesRichList.setInitialSortColumn(this.viewsConfig.getDefaultSortColumn(PAGE_NAME_BROWSE));
            this.spacesRichList.setInitialSortDescending(this.viewsConfig.hasDescendingSort(PAGE_NAME_BROWSE));
        }
        if (this.externalForceRefresh) {
            this.spacesRichList.setValue(null);
        }
    }

    public UIRichList getSpacesRichList() {
        return this.spacesRichList;
    }

    public UIStatusMessage getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(UIStatusMessage statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getDeleteMessage() {
        return this.deleteMessage;
    }

    public void setDeleteMessage(String deleteMessage) {
        this.deleteMessage = deleteMessage;
    }

    public List<Node> getNodes() {
        if (this.containerNodes == null) {
            if (this.navigator.getSearchContext() == null) {
                this.queryBrowseNodes(this.navigator.getCurrentNodeId());
            } else {
                this.searchBrowseNodes(this.navigator.getSearchContext());
            }
        }
        List<Node> result = this.containerNodes;
        return result;
    }

    public List<Node> getContent() {
        if (this.contentNodes == null) {
            if (this.navigator.getSearchContext() == null) {
                this.queryBrowseNodes(this.navigator.getCurrentNodeId());
            } else {
                this.searchBrowseNodes(this.navigator.getSearchContext());
            }
        }
        List<Node> result = this.contentNodes;
        return result;
    }

    public List<Node> getParentNodes(NodeRef currNodeRef) {
        if (this.parentContainerNodes == null) {
            long startTime = 0L;
            if (logger.isDebugEnabled()) {
                startTime = System.currentTimeMillis();
            }
            UserTransaction tx = null;
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                tx = Repository.getUserTransaction(context, true);
                tx.begin();
                NodeRef parentRef = this.getNodeService().getPrimaryParent(currNodeRef).getParentRef();
                List children = this.getFileFolderService().list(parentRef);
                this.parentContainerNodes = new ArrayList<Node>(children.size());
                for (FileInfo fileInfo : children) {
                    NodeRef nodeRef = fileInfo.getNodeRef();
                    QName type = this.getNodeService().getType(nodeRef);
                    TypeDefinition typeDef = this.getDictionaryService().getType(type);
                    if (typeDef != null) {
                        MapNode node = null;
                        if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_FOLDER) && !this.getDictionaryService().isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER)) {
                            node = new MapNode(nodeRef, this.getNodeService(), fileInfo.getProperties());
                            node.addPropertyResolver("icon", this.resolverSpaceIcon);
                            node.addPropertyResolver("smallIcon", this.resolverSmallIcon);
                            this.parentContainerNodes.add(node);
                            continue;
                        }
                        if (!ApplicationModel.TYPE_FOLDERLINK.equals((Object)type)) continue;
                        node = new MapNode(nodeRef, this.getNodeService(), fileInfo.getProperties());
                        node.addPropertyResolver("icon", this.resolverSpaceIcon);
                        node.addPropertyResolver("smallIcon", this.resolverSmallIcon);
                        this.parentContainerNodes.add(node);
                        continue;
                    }
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn((Object)("Found invalid object in database: id = " + nodeRef + ", type = " + type));
                }
                tx.commit();
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), refErr.getNodeRef()), refErr);
                this.parentContainerNodes = Collections.emptyList();
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {}
            }
            catch (Throwable err) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
                this.parentContainerNodes = Collections.emptyList();
                try {
                    if (tx != null) {
                        tx.rollback();
                    }
                }
                catch (Exception tex) {
                    // empty catch block
                }
            }
            if (logger.isDebugEnabled()) {
                long endTime = System.currentTimeMillis();
                logger.debug((Object)("Time to query and build map parent nodes: " + (endTime - startTime) + "ms"));
            }
        }
        List<Node> result = this.parentContainerNodes;
        return result;
    }

    public boolean isSitesSpace() {
        QName currentNodeType;
        boolean siteSpace = false;
        Node currentNode = this.navigator.getCurrentNode();
        if (currentNode != null && (SiteModel.TYPE_SITES.isMatch(currentNodeType = currentNode.getType()) || SiteModel.TYPE_SITE.isMatch(currentNodeType) || this.getDictionaryService().isSubClass(currentNodeType, SiteModel.TYPE_SITE))) {
            siteSpace = true;
        }
        return siteSpace;
    }

    public String getSitesSpaceWarningHTML() {
        FacesContext context = FacesContext.getCurrentInstance();
        String contextPath = context.getExternalContext().getRequestContextPath();
        StringBuilder html = new StringBuilder();
        try {
            html.append("<tr valign='top'>");
            html.append("<td style='background-image: url(");
            html.append(contextPath);
            html.append("/images/parts/whitepanel_4.gif)' ");
            html.append("width='4'></td><td style='padding:4px'>");
            StringWriter writer = new StringWriter();
            PanelGenerator.generatePanelStart(writer, contextPath, "yellowInner", "#ffffcc");
            html.append(writer.toString());
            html.append("<table cellpadding='0' cellspacing='0' border='0' width='100%'>");
            html.append("<tr><td valign='top' style='padding-top: 2px' width='20'>");
            html.append("<img src='");
            html.append(contextPath);
            html.append("/images/icons/warning.gif' width='16' height='16' /></td>");
            html.append("<td class='mainSubText'>");
            html.append(Application.getMessage(context, "sites_space_warning"));
            html.append("</td></tr></table>");
            writer = new StringWriter();
            PanelGenerator.generatePanelEnd(writer, contextPath, "yellowInner");
            html.append(writer.toString());
            html.append("</td><td style='background-image: url(");
            html.append(contextPath);
            html.append("/images/parts/whitepanel_6.gif)'");
            html.append("width='4'></td></tr>");
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
        }
        return html.toString();
    }

    public void setupCommonBindingProperties(Node node) {
        node.addPropertyResolver("url", this.resolverUrl);
        if (ApplicationModel.TYPE_FILELINK.equals((Object)node.getType())) {
            node.addPropertyResolver("downloadUrl", this.resolverLinkDownload);
        } else {
            node.addPropertyResolver("downloadUrl", this.resolverDownload);
        }
        node.addPropertyResolver("webdavUrl", this.resolverWebdavUrl);
        node.addPropertyResolver("cifsPath", this.resolverCifsPath);
        node.addPropertyResolver("fileType16", this.resolverFileType16);
        node.addPropertyResolver("fileType32", this.resolverFileType32);
        node.addPropertyResolver("size", this.resolverSize);
        node.addPropertyResolver("lang", this.resolverLang);
    }

    @Override
    public void contextUpdated() {
        this.invalidateComponents();
    }

    @Override
    public void areaChanged() {
    }

    @Override
    public void spaceChanged() {
    }

    public void addNodeEventListener(NodeEventListener listener) {
        if (this.nodeEventListeners == null) {
            this.nodeEventListeners = new HashSet<NodeEventListener>();
        }
        this.nodeEventListeners.add(listener);
    }

    public void removeNodeEventListener(NodeEventListener listener) {
        if (this.nodeEventListeners != null) {
            this.nodeEventListeners.remove(listener);
        }
    }

    public void viewModeChanged(ActionEvent event) {
        UIModeList viewList = (UIModeList)event.getComponent();
        String viewMode = viewList.getValue().toString();
        if (!VIEWMODE_DASHBOARD.equals(viewMode)) {
            int pageSize = this.viewsConfig.getDefaultPageSize(PAGE_NAME_BROWSE, viewMode);
            this.setPageSizeContent(pageSize);
            this.setPageSizeSpaces(pageSize);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Browse view page size set to: " + pageSize));
            }
            this.setDashboardView(false);
            this.setBrowseViewMode(viewMode);
            this.navigator.setupDispatchContext(this.navigator.getCurrentNode());
            FacesContext fc = FacesContext.getCurrentInstance();
            String outcome = null;
            String viewId = fc.getViewRoot().getViewId();
            if (!viewId.equals(BROWSE_VIEW_ID) && !viewId.equals(CATEGORY_VIEW_ID)) {
                outcome = PAGE_NAME_BROWSE;
            }
            fc.getApplication().getNavigationHandler().handleNavigation(fc, null, outcome);
        } else {
            this.setDashboardView(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryBrowseNodes(String parentNodeId) {
        long startTime = 0L;
        if (logger.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        UserTransaction tx = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            tx = Repository.getUserTransaction(context, true);
            tx.begin();
            NodeRef parentRef = parentNodeId == null ? this.getNodeService().getRootNode(Repository.getStoreRef()) : new NodeRef(Repository.getStoreRef(), parentNodeId);
            List children = null;
            FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.webclient);
            try {
                children = this.getFileFolderService().list(parentRef);
            }
            finally {
                FileFilterMode.clearClient();
            }
            this.containerNodes = new ArrayList<Node>(children.size());
            this.contentNodes = new ArrayList<Node>(children.size());
            Set<NodeEventListener> nodeEventListeners = this.getNodeEventListeners();
            for (FileInfo fileInfo : children) {
                NodeRef nodeRef = fileInfo.getNodeRef();
                QName type = this.getNodeService().getType(nodeRef);
                TypeDefinition typeDef = this.getDictionaryService().getType(type);
                if (typeDef != null) {
                    NodeRef destRef;
                    MapNode node = null;
                    if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CONTENT)) {
                        node = new MapNode(nodeRef, this.getNodeService(), fileInfo.getProperties());
                        this.setupCommonBindingProperties(node);
                        this.contentNodes.add(node);
                    } else if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_FOLDER) && !this.getDictionaryService().isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER)) {
                        node = new MapNode(nodeRef, this.getNodeService(), fileInfo.getProperties());
                        node.addPropertyResolver("icon", this.resolverSpaceIcon);
                        node.addPropertyResolver("smallIcon", this.resolverSmallIcon);
                        this.containerNodes.add(node);
                    } else if (ApplicationModel.TYPE_FILELINK.equals((Object)type)) {
                        node = new MapNode(nodeRef, this.getNodeService(), fileInfo.getProperties());
                        destRef = (NodeRef)node.getProperties().get(ContentModel.PROP_LINK_DESTINATION);
                        if (destRef != null && new Node(destRef).hasPermission("Read")) {
                            node.addPropertyResolver("url", this.resolverLinkUrl);
                            node.addPropertyResolver("downloadUrl", this.resolverLinkDownload);
                            node.addPropertyResolver("webdavUrl", this.resolverLinkWebdavUrl);
                            node.addPropertyResolver("cifsPath", this.resolverLinkCifsPath);
                            node.addPropertyResolver("fileType16", this.resolverFileType16);
                            node.addPropertyResolver("fileType32", this.resolverFileType32);
                            node.addPropertyResolver("lang", this.resolverLang);
                            this.contentNodes.add(node);
                        }
                    } else if (ApplicationModel.TYPE_FOLDERLINK.equals((Object)type) && (destRef = (NodeRef)(node = new MapNode(nodeRef, this.getNodeService(), fileInfo.getProperties())).getProperties().get(ContentModel.PROP_LINK_DESTINATION)) != null && new Node(destRef).hasPermission("Read")) {
                        node.addPropertyResolver("icon", this.resolverSpaceIcon);
                        node.addPropertyResolver("smallIcon", this.resolverSmallIcon);
                        this.containerNodes.add(node);
                    }
                    if (node == null) continue;
                    for (NodeEventListener listener : nodeEventListeners) {
                        listener.created(node, type);
                    }
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn((Object)("Found invalid object in database: id = " + nodeRef + ", type = " + type));
            }
            tx.commit();
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), refErr.getNodeRef()), refErr);
            this.containerNodes = Collections.emptyList();
            this.contentNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {}
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
            this.containerNodes = Collections.emptyList();
            this.contentNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        if (logger.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            logger.debug((Object)("Time to query and build map nodes: " + (endTime - startTime) + "ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchBrowseNodes(SearchContext searchContext) {
        String query;
        long startTime = 0L;
        if (logger.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
        }
        if ((query = searchContext.buildQuery(BrowseBean.getMinimumSearchLength())) == null) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_SEARCH_MINIMUM), BrowseBean.getMinimumSearchLength()));
            this.containerNodes = Collections.emptyList();
            this.contentNodes = Collections.emptyList();
            return;
        }
        UserTransaction tx = null;
        ResultSet results = null;
        try {
            tx = Repository.getUserTransaction(FacesContext.getCurrentInstance(), true);
            tx.begin();
            SearchParameters sp = new SearchParameters();
            sp.setLanguage("lucene");
            sp.setQuery(query);
            sp.addStore(Repository.getStoreRef());
            int searchLimit = Application.getClientConfig(FacesContext.getCurrentInstance()).getSearchMaxResults();
            if (searchLimit > 0) {
                sp.setLimitBy(LimitBy.FINAL_SIZE);
                sp.setLimit(searchLimit);
            }
            results = this.getSearchService().query(sp);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Search results returned: " + results.length()));
            }
            this.containerNodes = new ArrayList<Node>(results.length());
            this.contentNodes = new ArrayList<Node>(results.length());
            if (results.length() != 0) {
                Set<NodeEventListener> nodeEventListeners = this.getNodeEventListeners();
                for (ResultSetRow row : results) {
                    NodeRef nodeRef = row.getNodeRef();
                    if (this.getNodeService().exists(nodeRef)) {
                        QName type = this.getNodeService().getType(nodeRef);
                        TypeDefinition typeDef = this.getDictionaryService().getType(type);
                        if (typeDef != null) {
                            NodeRef destRef;
                            MapNode node = null;
                            if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_FOLDER) && !this.getDictionaryService().isSubClass(type, ContentModel.TYPE_SYSTEM_FOLDER)) {
                                node = new MapNode(nodeRef, this.getNodeService(), false);
                                node.addPropertyResolver("path", this.resolverPath);
                                node.addPropertyResolver("displayPath", this.resolverDisplayPath);
                                node.addPropertyResolver("icon", this.resolverSpaceIcon);
                                node.addPropertyResolver("smallIcon", this.resolverSmallIcon);
                                this.containerNodes.add(node);
                            } else if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CONTENT)) {
                                node = new MapNode(nodeRef, this.getNodeService(), false);
                                this.setupCommonBindingProperties(node);
                                node.addPropertyResolver("path", this.resolverPath);
                                node.addPropertyResolver("displayPath", this.resolverDisplayPath);
                                this.contentNodes.add(node);
                            } else if (ApplicationModel.TYPE_FILELINK.equals((Object)type)) {
                                node = new MapNode(nodeRef, this.getNodeService(), false);
                                destRef = (NodeRef)node.getProperties().get(ContentModel.PROP_LINK_DESTINATION);
                                if (new Node(destRef).hasPermission("Read")) {
                                    node.addPropertyResolver("url", this.resolverLinkUrl);
                                    node.addPropertyResolver("downloadUrl", this.resolverLinkDownload);
                                    node.addPropertyResolver("webdavUrl", this.resolverLinkWebdavUrl);
                                    node.addPropertyResolver("cifsPath", this.resolverLinkCifsPath);
                                    node.addPropertyResolver("fileType16", this.resolverFileType16);
                                    node.addPropertyResolver("fileType32", this.resolverFileType32);
                                    node.addPropertyResolver("lang", this.resolverLang);
                                    node.addPropertyResolver("path", this.resolverPath);
                                    node.addPropertyResolver("displayPath", this.resolverDisplayPath);
                                    this.contentNodes.add(node);
                                }
                            } else if (ApplicationModel.TYPE_FOLDERLINK.equals((Object)type) && new Node(destRef = (NodeRef)(node = new MapNode(nodeRef, this.getNodeService(), false)).getProperties().get(ContentModel.PROP_LINK_DESTINATION)).hasPermission("Read")) {
                                node.addPropertyResolver("icon", this.resolverSpaceIcon);
                                node.addPropertyResolver("smallIcon", this.resolverSmallIcon);
                                node.addPropertyResolver("path", this.resolverPath);
                                node.addPropertyResolver("displayPath", this.resolverDisplayPath);
                                this.containerNodes.add(node);
                            }
                            if (node == null) continue;
                            for (NodeEventListener listener : nodeEventListeners) {
                                listener.created(node, type);
                            }
                            continue;
                        }
                        if (!logger.isWarnEnabled()) continue;
                        logger.warn((Object)("Found invalid object in database: id = " + nodeRef + ", type = " + type));
                        continue;
                    }
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn((Object)("Missing object returned from search indexes: id = " + nodeRef + " search query: " + query));
                }
            }
            tx.commit();
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), refErr.getNodeRef()), refErr);
            this.containerNodes = Collections.emptyList();
            this.contentNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        catch (SearcherException serr) {
            logger.info((Object)("Search failed for: " + query), (Throwable)serr);
            Utils.addErrorMessage(Application.getMessage(FacesContext.getCurrentInstance(), "error_search_query"));
            this.containerNodes = Collections.emptyList();
            this.contentNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        catch (Throwable err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_search"), err.getMessage()), err);
            this.containerNodes = Collections.emptyList();
            this.contentNodes = Collections.emptyList();
            try {
                if (tx != null) {
                    tx.rollback();
                }
            }
            catch (Exception tex) {
                // empty catch block
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        if (logger.isDebugEnabled()) {
            long endTime = System.currentTimeMillis();
            logger.debug((Object)("Time to query and build map nodes: " + (endTime - startTime) + "ms"));
        }
    }

    public void search(ActionEvent event) {
        UISimpleSearch search = (UISimpleSearch)event.getComponent();
        this.navigator.setSearchContext(search.getSearchContext());
        this.navigateBrowseScreen();
    }

    public void closeSearch(ActionEvent event) {
        String currentNodeId = this.navigator.getCurrentNodeId();
        this.navigator.setCurrentNodeId(currentNodeId);
        NodeRef currentNodeRef = new NodeRef(Repository.getStoreRef(), currentNodeId);
        Node currentNode = new Node(currentNodeRef);
        this.navigator.setupDispatchContext(currentNode);
    }

    public void updateSpacesPageSize(ActionEvent event) {
        try {
            int size = Integer.parseInt(this.pageSizeSpacesStr);
            if (size >= 0) {
                this.pageSizeSpaces = size;
            } else {
                this.pageSizeSpacesStr = Integer.toString(this.pageSizeSpaces);
            }
        }
        catch (NumberFormatException err) {
            this.pageSizeSpacesStr = Integer.toString(this.pageSizeSpaces);
        }
    }

    public void updateContentPageSize(ActionEvent event) {
        try {
            int size = Integer.parseInt(this.pageSizeContentStr);
            if (size >= 0) {
                this.pageSizeContent = size;
            } else {
                this.pageSizeContentStr = Integer.toString(this.pageSizeContent);
            }
        }
        catch (NumberFormatException err) {
            this.pageSizeContentStr = Integer.toString(this.pageSizeContent);
        }
    }

    public void clickSpace(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        if (id != null && id.length() != 0) {
            try {
                NodeRef ref = new NodeRef(Repository.getStoreRef(), id);
                if (ApplicationModel.TYPE_FOLDERLINK.equals((Object)this.getNodeService().getType(ref))) {
                    ref = (NodeRef)this.getNodeService().getProperty(ref, ContentModel.PROP_LINK_DESTINATION);
                }
                this.clickSpace(ref);
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
            }
        }
    }

    public void clickSpace(NodeRef nodeRef) {
        this.updateUILocation(nodeRef);
    }

    public void clickSpacePath(ActionEvent event) {
        UINodePath.PathElementEvent pathEvent = (UINodePath.PathElementEvent)event;
        NodeRef ref = pathEvent.NodeReference;
        try {
            this.updateUILocation(ref);
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), ref.getId()));
        }
    }

    public void clickDescendantSpace(ActionEvent event) {
        UINodeDescendants.NodeSelectedEvent nodeEvent = (UINodeDescendants.NodeSelectedEvent)event;
        NodeRef nodeRef = nodeEvent.NodeReference;
        if (nodeRef == null) {
            throw new IllegalStateException("NodeRef returned from UINodeDescendants.NodeSelectedEvent cannot be null!");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Selected noderef Id: " + nodeRef.getId()));
        }
        try {
            ChildAssociationRef parentAssocRef = this.getNodeService().getPrimaryParent(nodeRef);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Selected item getPrimaryParent().getChildRef() noderef Id:  " + parentAssocRef.getChildRef().getId()));
                logger.debug((Object)("Selected item getPrimaryParent().getParentRef() noderef Id: " + parentAssocRef.getParentRef().getId()));
                logger.debug((Object)("Current value getNavigator().getCurrentNodeId() noderef Id: " + this.navigator.getCurrentNodeId()));
            }
            if (!nodeEvent.IsParent) {
                this.updateUILocation(parentAssocRef.getParentRef());
                this.updateUILocation(nodeRef);
            } else {
                this.updateUILocation(nodeRef);
            }
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), nodeRef.getId()));
        }
    }

    public void setupSpaceAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        this.setupSpaceAction(id, true);
    }

    public void setupSpaceAction(String id, boolean invalidate) {
        if (id != null && id.length() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setup for action, setting current space to: " + id));
            }
            try {
                NodeRef ref = new NodeRef(Repository.getStoreRef(), id);
                Node node = new Node(ref);
                node.addPropertyResolver("icon", this.resolverSpaceIcon);
                this.setActionSpace(node);
                this.navigator.setupDispatchContext(node);
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
            }
        } else {
            this.setActionSpace(null);
        }
        if (invalidate) {
            UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        }
    }

    public void setupDeleteAction(ActionEvent event) {
        String message = null;
        this.setupSpaceAction(event);
        Node node = this.getActionSpace();
        if (node != null) {
            FacesContext fc = FacesContext.getCurrentInstance();
            NodeRef companyRootRef = new NodeRef(Repository.getStoreRef(), Application.getCompanyRootId(fc));
            if (node.getNodeRef().equals((Object)companyRootRef)) {
                message = Application.getMessage(fc, MSG_DELETE_COMPANYROOT);
            }
        }
        this.setDeleteMessage(message);
    }

    public void setupContentAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        this.setupContentAction(params.get("id"), true);
    }

    public void setupMLContainerContentAction(ActionEvent event) {
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String id = params.get("id");
        NodeRef translation = new NodeRef(Repository.getStoreRef(), id);
        FacesContext fc = FacesContext.getCurrentInstance();
        DocumentDetailsDialog docDetails = (DocumentDetailsDialog)FacesHelper.getManagedBean(fc, "DocumentDetailsDialog");
        docDetails.setTranslationDocument(new MapNode(translation));
        MultilingualManageDialog mmDialog = (MultilingualManageDialog)FacesHelper.getManagedBean(fc, "MultilingualManageDialog");
        mmDialog.setTranslationDocument(docDetails.getTranslationDocument());
        NodeRef mlContainer = this.getMultilingualContentService().getTranslationContainer(translation);
        this.setupContentAction(mlContainer.getId(), true);
    }

    public void setupContentAction(String id, boolean invalidate) {
        if (id != null && id.length() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setup for action, setting current document to: " + id));
            }
            try {
                NodeRef ref = new NodeRef(Repository.getStoreRef(), id);
                MapNode node = new MapNode(ref);
                if (ApplicationModel.TYPE_FILELINK.equals((Object)node.getType())) {
                    node.addPropertyResolver("url", this.resolverLinkDownload);
                    node.addPropertyResolver("downloadUrl", this.resolverLinkDownload);
                } else {
                    node.addPropertyResolver("url", this.resolverDownload);
                    node.addPropertyResolver("downloadUrl", this.resolverDownload);
                }
                node.addPropertyResolver("webdavUrl", this.resolverWebdavUrl);
                node.addPropertyResolver("cifsPath", this.resolverCifsPath);
                node.addPropertyResolver("fileType32", this.resolverFileType32);
                node.addPropertyResolver("mimetype", this.resolverMimetype);
                node.addPropertyResolver("encoding", this.resolverEncoding);
                node.addPropertyResolver("size", this.resolverSize);
                node.addPropertyResolver("lang", this.resolverLang);
                for (NodeEventListener listener : this.getNodeEventListeners()) {
                    listener.created(node, node.getType());
                }
                DocumentDetailsDialog docDetails = (DocumentDetailsDialog)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("DocumentDetailsDialog");
                if (docDetails != null) {
                    docDetails.reset();
                }
                this.setDocument(node);
                this.navigator.setupDispatchContext(node);
            }
            catch (InvalidNodeRefException refErr) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_noderef"), id));
                throw new AbortProcessingException("Invalid node reference");
            }
        } else {
            this.setDocument(null);
        }
        if (invalidate) {
            UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        }
    }

    public void removeSpaceFromBreadcrumb(Node node) {
        List<IBreadcrumbHandler> location = this.navigator.getLocation();
        IBreadcrumbHandler handler = location.get(location.size() - 1);
        if (handler instanceof IRepoBreadcrumbHandler && ((IRepoBreadcrumbHandler)handler).getNodeRef().equals((Object)node.getNodeRef())) {
            location.remove(location.size() - 1);
            if (location.size() != 0) {
                handler = location.get(location.size() - 1);
                if (handler instanceof IRepoBreadcrumbHandler) {
                    this.navigator.setCurrentNodeId(((IRepoBreadcrumbHandler)handler).getNodeRef().getId());
                } else {
                    this.navigator.processToolbarLocation("userhome", false);
                }
            } else {
                this.navigator.processToolbarLocation("userhome", false);
            }
        }
    }

    public void externalAccessRefresh() {
        this.externalForceRefresh = true;
    }

    public void expandPanel(ActionEvent event) {
        if (event instanceof UIPanel.ExpandedEvent) {
            String id = event.getComponent().getId();
            this.panels.put(id, ((UIPanel.ExpandedEvent)event).State);
        }
    }

    private void initFromClientConfig() {
        ConfigService config = Application.getConfigService(FacesContext.getCurrentInstance());
        this.viewsConfig = (ViewsConfigElement)config.getConfig((Object)"Views").getConfigElement("views");
        this.browseViewMode = this.viewsConfig.getDefaultView(PAGE_NAME_BROWSE);
        int pageSize = this.viewsConfig.getDefaultPageSize(PAGE_NAME_BROWSE, this.browseViewMode);
        this.setPageSizeContent(pageSize);
        this.setPageSizeSpaces(pageSize);
    }

    private Set<NodeEventListener> getNodeEventListeners() {
        if (this.nodeEventListeners == null || Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
            ConfigElement listenerElement;
            FacesContext fc;
            Config listenerConfig;
            HashSet<NodeEventListener> allNodeEventListeners = new HashSet<NodeEventListener>();
            if (Application.isDynamicConfig(FacesContext.getCurrentInstance()) && this.nodeEventListeners != null) {
                allNodeEventListeners.addAll(this.nodeEventListeners);
            }
            if ((listenerConfig = Application.getConfigService(fc = FacesContext.getCurrentInstance()).getConfig((Object)"Node Event Listeners")) != null && (listenerElement = listenerConfig.getConfigElement("node-event-listeners")) != null) {
                for (ConfigElement child : listenerElement.getChildren()) {
                    String listenerName;
                    Object bean;
                    if (!child.getName().equals("listener") || !((bean = FacesHelper.getManagedBean(fc, listenerName = child.getValue().trim())) instanceof NodeEventListener)) continue;
                    allNodeEventListeners.add((NodeEventListener)bean);
                }
            }
            if (Application.isDynamicConfig(FacesContext.getCurrentInstance())) {
                return allNodeEventListeners;
            }
            this.nodeEventListeners = allNodeEventListeners;
        }
        return this.nodeEventListeners;
    }

    public void updateUILocation(NodeRef ref) {
        List<IBreadcrumbHandler> location = this.navigator.getLocation();
        if (location.size() != 0) {
            boolean foundNode = false;
            for (int i = 0; i < location.size(); ++i) {
                NodeRef nodeRef;
                IBreadcrumbHandler element = location.get(i);
                if (!(element instanceof IRepoBreadcrumbHandler) || !ref.equals((Object)(nodeRef = ((IRepoBreadcrumbHandler)element).getNodeRef()))) continue;
                int count = location.size();
                for (int n = i + 1; n < count; ++n) {
                    location.remove(i + 1);
                }
                foundNode = true;
                break;
            }
            if (!foundNode) {
                FacesContext context = FacesContext.getCurrentInstance();
                String breadcrumbMode = Application.getClientConfig(context).getBreadcrumbMode();
                if ("location".equals(breadcrumbMode)) {
                    Repository.setupBreadcrumbLocation(context, this.navigator, location, ref);
                } else {
                    String name = Repository.getNameForNode(this.getNodeService(), ref);
                    location.add(new BrowseBreadcrumbHandler(ref, name));
                }
            }
        } else {
            String name = Repository.getNameForNode(this.getNodeService(), ref);
            location.add(new BrowseBreadcrumbHandler(ref, name));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updated breadcrumb: " + location));
        }
        this.navigator.setCurrentNodeId(ref.getId());
        this.navigator.setupDispatchContext(new Node(ref));
        UIContextService.getInstance(FacesContext.getCurrentInstance()).spaceChanged();
        this.navigateBrowseScreen();
    }

    private void invalidateComponents() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Invalidating browse components...");
        }
        if (this.contentRichList != null) {
            this.contentRichList.setValue(null);
            if (this.navigator.getSearchContext() != null) {
                this.contentRichList.clearSort();
            }
        }
        if (this.spacesRichList != null) {
            this.spacesRichList.setValue(null);
            if (this.navigator.getSearchContext() != null) {
                this.spacesRichList.clearSort();
            }
        }
        this.containerNodes = null;
        this.contentNodes = null;
        this.parentContainerNodes = null;
    }

    private boolean isViewCurrent() {
        return FacesContext.getCurrentInstance().getViewRoot().getViewId().equals(BROWSE_VIEW_ID);
    }

    private void navigateBrowseScreen() {
        String outcome = null;
        if (!this.isViewCurrent()) {
            outcome = PAGE_NAME_BROWSE;
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        fc.getApplication().getNavigationHandler().handleNavigation(fc, null, outcome);
    }

    public void deleteFile(ActionEvent event) {
        this.setupContentAction(event);
        UIActionLink link = (UIActionLink)event.getComponent();
        Map<String, String> params = link.getParameterMap();
        String ref = params.get("ref");
        if (ref != null && ref.length() > 0) {
            List parents;
            NodeRef nodeRef = new NodeRef(ref);
            NodeRef workingCopyNodeRef = this.getCheckOutCheckInService().getWorkingCopy(nodeRef);
            if (workingCopyNodeRef != null) {
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), MSG_CANNOT_DELETE_NODE_HAS_WORKING_COPY), this.getNodeService().getProperty(nodeRef, ContentModel.PROP_NAME)));
                return;
            }
            boolean hasMultipleParents = false;
            boolean showDeleteAssocDialog = false;
            Node node = this.getDocument();
            QName type = node.getType();
            TypeDefinition typeDef = this.dictionaryService.getType(type);
            if (!(type.equals((Object)ContentModel.TYPE_MULTILINGUAL_CONTAINER) || node.hasAspect(ContentModel.ASPECT_MULTILINGUAL_EMPTY_TRANSLATION) || node.hasAspect(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT) || type.equals((Object)ContentModel.TYPE_LINK) || this.dictionaryService.isSubClass(typeDef.getName(), ContentModel.TYPE_LINK) || (parents = this.nodeService.getParentAssocs(node.getNodeRef(), (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL)) == null || parents.size() <= 1)) {
                hasMultipleParents = true;
            }
            if (this.navigator.getSearchContext() == null && hasMultipleParents) {
                ChildAssociationRef assoc;
                NodeRef parentSpace = this.navigator.getCurrentNode().getNodeRef();
                showDeleteAssocDialog = !parentSpace.equals((Object)(assoc = this.nodeService.getPrimaryParent(node.getNodeRef())).getParentRef());
            }
            FacesContext fc = FacesContext.getCurrentInstance();
            if (showDeleteAssocDialog) {
                fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:deleteFileAssoc");
            } else {
                HashMap<String, String> dialogParams = new HashMap<String, String>(1);
                dialogParams.put("hasMultipleParents", Boolean.toString(hasMultipleParents));
                Application.getDialogManager().setupParameters(dialogParams);
                fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:deleteFile");
            }
        }
    }

    public void deleteSpace(ActionEvent event) {
        this.setupDeleteAction(event);
        boolean hasMultipleParents = false;
        boolean showDeleteAssocDialog = false;
        Node node = this.getActionSpace();
        List parents = this.nodeService.getParentAssocs(node.getNodeRef(), (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL);
        if (parents != null && parents.size() > 1) {
            hasMultipleParents = true;
        }
        if (this.navigator.getSearchContext() == null && hasMultipleParents) {
            ChildAssociationRef assoc;
            NodeRef parentSpace = this.navigator.getCurrentNode().getNodeRef();
            showDeleteAssocDialog = !parentSpace.equals((Object)(assoc = this.nodeService.getPrimaryParent(node.getNodeRef())).getParentRef());
        }
        FacesContext fc = FacesContext.getCurrentInstance();
        if (showDeleteAssocDialog) {
            fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:deleteSpaceAssoc");
        } else {
            HashMap<String, String> dialogParams = new HashMap<String, String>(1);
            dialogParams.put("hasMultipleParents", Boolean.toString(hasMultipleParents));
            Application.getDialogManager().setupParameters(dialogParams);
            fc.getApplication().getNavigationHandler().handleNavigation(fc, null, "dialog:deleteSpace");
        }
    }

    private class BrowseBreadcrumbHandler
    implements IRepoBreadcrumbHandler {
        private static final long serialVersionUID = 3833183653173016630L;
        private NodeRef nodeRef;
        private String label;

        public BrowseBreadcrumbHandler(NodeRef nodeRef, String label) {
            this.label = label;
            this.nodeRef = nodeRef;
        }

        @Override
        public String toString() {
            return this.label;
        }

        @Override
        public String navigationOutcome(UIBreadcrumb breadcrumb) {
            BrowseBean.this.navigator.setCurrentNodeId(this.nodeRef.getId());
            BrowseBean.this.navigator.setLocation((List)breadcrumb.getValue());
            BrowseBean.this.navigator.setupDispatchContext(new Node(this.nodeRef));
            UIContextService.getInstance(FacesContext.getCurrentInstance()).spaceChanged();
            return BrowseBean.this.isViewCurrent() ? null : BrowseBean.PAGE_NAME_BROWSE;
        }

        @Override
        public NodeRef getNodeRef() {
            return this.nodeRef;
        }
    }
}

