/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.bean;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.repo.ContentDiskInterface;
import org.alfresco.jlan.server.config.ServerConfigurationAccessor;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.FileTypeImageUtils;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.admin.RepoUsage;
import org.alfresco.service.cmr.repository.FileTypeImageSize;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.web.app.Application;
import org.alfresco.web.app.context.UIContextService;
import org.alfresco.web.app.servlet.FacesHelper;
import org.alfresco.web.bean.repository.Node;
import org.alfresco.web.bean.repository.Repository;
import org.alfresco.web.bean.repository.User;
import org.alfresco.web.bean.search.SearchContext;
import org.alfresco.web.bean.spaces.SpaceDetailsDialog;
import org.alfresco.web.bean.users.UserPreferencesBean;
import org.alfresco.web.config.ClientConfigElement;
import org.alfresco.web.ui.common.Utils;
import org.alfresco.web.ui.common.component.IBreadcrumbHandler;
import org.alfresco.web.ui.common.component.UIBreadcrumb;
import org.alfresco.web.ui.common.component.UIModeList;
import org.alfresco.web.ui.repo.component.IRepoBreadcrumbHandler;
import org.alfresco.web.ui.repo.component.shelf.UIShelf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NavigationBean
implements Serializable {
    private static final long serialVersionUID = -648110889585522227L;
    public static final String BEAN_NAME = "NavigationBean";
    private static Log logger = LogFactory.getLog(NavigationBean.class);
    private static Log s_logger = LogFactory.getLog(NavigationBean.class);
    public static final String LOCATION_COMPANY = "companyhome";
    public static final String LOCATION_HOME = "userhome";
    public static final String LOCATION_GUEST = "guesthome";
    public static final String LOCATION_MYALFRESCO = "myalfresco";
    public static final String MSG_MYALFRESCO = "my_alfresco";
    public static final String MSG_MYHOME = "my_home";
    public static final String MSG_COMPANYHOME = "company_home";
    public static final String MSG_GUESTHOME = "guest_home";
    private static final String OUTCOME_MYALFRESCO = "myalfresco";
    private static final String OUTCOME_BROWSE = "browse";
    private static final String ERROR_DELETED_FOLDER = "error_deleted_folder";
    private transient NodeService nodeService;
    private transient SearchService searchService;
    private transient NamespaceService namespaceService;
    private transient RuleService ruleService;
    private transient RepoAdminService repoAdminService;
    private transient ServerConfigurationAccessor serverConfiguration;
    protected ContentDiskInterface contentDiskDriver;
    protected ClientConfigElement clientConfig = null;
    UserPreferencesBean preferences;
    private transient MutableAuthenticationService authService;
    private transient PermissionService permissionService;
    private String cifsServerPath;
    private String currentNodeId;
    private Node currentNode = null;
    private Node dispatchContext = null;
    private Node guestHomeNode = null;
    private Node companyHomeNode = null;
    private String toolbarLocation = null;
    private SearchContext searchContext;
    private boolean shelfExpanded = true;
    private boolean[] shelfItemExpanded = new boolean[]{true, true, true, false, false};
    private List<IBreadcrumbHandler> location = null;
    private String helpUrl;

    public NavigationBean() {
        this.initFromClientConfig();
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected NodeService getNodeService() {
        if (this.nodeService == null) {
            this.nodeService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNodeService();
        }
        return this.nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    protected SearchService getSearchService() {
        if (this.searchService == null) {
            this.searchService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getSearchService();
        }
        return this.searchService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    protected NamespaceService getNamespaceService() {
        if (this.namespaceService == null) {
            this.namespaceService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getNamespaceService();
        }
        return this.namespaceService;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public RepoAdminService getRepoAdminService() {
        if (this.repoAdminService == null) {
            this.repoAdminService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getRepoAdminService();
        }
        return this.repoAdminService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    protected RuleService getRuleService() {
        if (this.ruleService == null) {
            this.ruleService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getRuleService();
        }
        return this.ruleService;
    }

    public void setServerConfiguration(ServerConfigurationAccessor serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    protected ServerConfigurationAccessor getServerConfiguration() {
        if (this.serverConfiguration == null) {
            this.serverConfiguration = (ServerConfigurationAccessor)FacesHelper.getManagedBean(FacesContext.getCurrentInstance(), "fileServerConfiguration");
        }
        return this.serverConfiguration;
    }

    public void setContentDiskDriver(ContentDiskInterface contentDiskDriver) {
        this.contentDiskDriver = contentDiskDriver;
    }

    protected ClientConfigElement getClientConfig() {
        if (this.clientConfig == null) {
            this.clientConfig = Application.getClientConfig(FacesContext.getCurrentInstance());
        }
        return this.clientConfig;
    }

    public void setUserPreferencesBean(UserPreferencesBean preferences) {
        this.preferences = preferences;
    }

    public void setAuthenticationService(MutableAuthenticationService authService) {
        this.authService = authService;
    }

    protected MutableAuthenticationService getAuthService() {
        if (this.authService == null) {
            this.authService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getAuthenticationService();
        }
        return this.authService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    protected PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getPermissionService();
        }
        return this.permissionService;
    }

    public User getCurrentUser() {
        return Application.getCurrentUser(FacesContext.getCurrentInstance());
    }

    public boolean getInPortalServer() {
        return Application.inPortalServer();
    }

    public boolean isShelfExpanded() {
        return this.shelfExpanded;
    }

    public void setShelfExpanded(boolean expanded) {
        this.shelfExpanded = expanded;
    }

    public String getWorkAreaWidth() {
        return this.shelfExpanded ? "80%" : "100%";
    }

    public boolean[] getShelfItemExpanded() {
        return this.shelfItemExpanded;
    }

    public void setShelfItemExpanded(boolean[] shelfItemExpanded) {
        this.shelfItemExpanded = shelfItemExpanded;
    }

    public String getToolbarLocation() {
        if (this.toolbarLocation == null) {
            this.toolbarLocation = this.preferences.getStartLocation();
            if (LOCATION_COMPANY.equals(this.toolbarLocation)) {
                if (!this.getCompanyHomeVisible()) {
                    this.toolbarLocation = null;
                }
            } else if (LOCATION_GUEST.equals(this.toolbarLocation) && !this.getGuestHomeVisible()) {
                this.toolbarLocation = null;
            }
            if (this.toolbarLocation == null) {
                this.toolbarLocation = LOCATION_HOME;
                this.preferences.setStartLocation(this.toolbarLocation);
            }
        }
        return this.toolbarLocation;
    }

    public void setToolbarLocation(String location) {
        this.toolbarLocation = location;
    }

    public void processToolbarLocation(String location, boolean navigate) {
        this.toolbarLocation = location;
        FacesContext context = FacesContext.getCurrentInstance();
        if (LOCATION_COMPANY.equals(location)) {
            ArrayList<IBreadcrumbHandler> elements = new ArrayList<IBreadcrumbHandler>(1);
            Node companyHome = this.getCompanyHomeNode();
            elements.add(new NavigationBreadcrumbHandler(companyHome.getNodeRef(), companyHome.getName()));
            this.setLocation(elements);
            this.setCurrentNodeId(companyHome.getId());
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Created breadcrumb for companyhome: " + elements));
            }
            UIContextService.getInstance(FacesContext.getCurrentInstance()).areaChanged();
            if (navigate) {
                context.getApplication().getNavigationHandler().handleNavigation(context, null, OUTCOME_BROWSE);
            }
        } else if (LOCATION_HOME.equals(location)) {
            ArrayList<IBreadcrumbHandler> elements = new ArrayList<IBreadcrumbHandler>(1);
            String homeSpaceId = Application.getCurrentUser(context).getHomeSpaceId();
            NodeRef homeSpaceRef = new NodeRef(Repository.getStoreRef(), homeSpaceId);
            if (this.clientConfig.getBreadcrumbMode().equals("location")) {
                Repository.setupBreadcrumbLocation(context, this, elements, homeSpaceRef);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Created breadcrumb location for userhome: " + elements));
                }
            } else {
                String homeSpaceName = Repository.getNameForNode(this.getNodeService(), homeSpaceRef);
                elements.add(new NavigationBreadcrumbHandler(homeSpaceRef, homeSpaceName));
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Created breadcrumb path for userhome: " + elements));
                }
            }
            this.setLocation(elements);
            this.setCurrentNodeId(homeSpaceRef.getId());
            UIContextService.getInstance(FacesContext.getCurrentInstance()).areaChanged();
            if (navigate) {
                context.getApplication().getNavigationHandler().handleNavigation(context, null, OUTCOME_BROWSE);
            }
        } else if (LOCATION_GUEST.equals(location)) {
            ArrayList<IBreadcrumbHandler> elements = new ArrayList<IBreadcrumbHandler>(1);
            Node guestHome = this.getGuestHomeNode();
            if (this.clientConfig.getBreadcrumbMode().equals("location")) {
                Repository.setupBreadcrumbLocation(context, this, elements, guestHome.getNodeRef());
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Created breadcrumb location for guesthome: " + elements));
                }
            } else {
                elements.add(new NavigationBreadcrumbHandler(guestHome.getNodeRef(), guestHome.getName()));
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Created breadcrumb path for guesthome: " + elements));
                }
            }
            this.setLocation(elements);
            this.setCurrentNodeId(guestHome.getId());
            UIContextService.getInstance(FacesContext.getCurrentInstance()).areaChanged();
            if (navigate) {
                context.getApplication().getNavigationHandler().handleNavigation(context, null, OUTCOME_BROWSE);
            }
        } else if ("myalfresco".equals(location)) {
            if (this.getCurrentNodeId() == null) {
                String homeSpaceId = Application.getCurrentUser(context).getHomeSpaceId();
                NodeRef homeSpaceRef = new NodeRef(Repository.getStoreRef(), homeSpaceId);
                this.setCurrentNodeId(homeSpaceRef.getId());
            }
            ArrayList<IBreadcrumbHandler> elements = new ArrayList<IBreadcrumbHandler>(1);
            elements.add(new IBreadcrumbHandler(){

                @Override
                public String navigationOutcome(UIBreadcrumb breadcrumb) {
                    NavigationBean.this.setLocation((List)breadcrumb.getValue());
                    return "myalfresco";
                }

                @Override
                public String toString() {
                    return Application.getMessage(FacesContext.getCurrentInstance(), NavigationBean.MSG_MYALFRESCO);
                }
            });
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Created breadcrumb for myalfresco: " + elements));
            }
            this.setLocation(elements);
            UIContextService.getInstance(FacesContext.getCurrentInstance()).areaChanged();
            if (navigate) {
                context.getApplication().getNavigationHandler().handleNavigation(context, null, "myalfresco");
            }
        } else {
            context.getApplication().getNavigationHandler().handleNavigation(context, null, location);
        }
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public void setHelpUrl(String helpUrl) {
        if (this.helpUrl == null) {
            Descriptor serverDescriptor = Repository.getServiceRegistry(FacesContext.getCurrentInstance()).getDescriptorService().getServerDescriptor();
            Pattern p = Pattern.compile("\\{(\\w+\\.?\\w+)\\}");
            Matcher m = p.matcher(helpUrl);
            boolean result = m.find();
            if (result) {
                StringBuffer sb = new StringBuffer();
                String value = null;
                do {
                    m.appendReplacement(sb, (value = serverDescriptor.getDescriptor(m.group(1))) != null ? value : m.group(1));
                } while (result = m.find());
                m.appendTail(sb);
                helpUrl = sb.toString();
            }
            this.helpUrl = helpUrl;
        }
    }

    public int getRuleCount() {
        Node node = this.getCurrentNode();
        return node != null ? this.getRuleService().countRules(node.getNodeRef()) : 0;
    }

    public SearchContext getSearchContext() {
        return this.searchContext;
    }

    public void setSearchContext(SearchContext searchContext) {
        this.searchContext = searchContext;
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
    }

    public String getCurrentNodeId() {
        return this.currentNodeId;
    }

    public void setCurrentNodeId(String currentNodeId) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Setting current node id to: " + currentNodeId));
        }
        if (currentNodeId == null) {
            throw new AlfrescoRuntimeException("Can not set the current node id to null");
        }
        this.currentNodeId = currentNodeId;
        this.currentNode = null;
        this.searchContext = null;
        UIContextService.getInstance(FacesContext.getCurrentInstance()).notifyBeans();
        this.currentNode = null;
    }

    public boolean getHasCustomView() {
        return this.getHasWebscriptView() || this.getHasTemplateView();
    }

    public boolean getHasTemplateView() {
        Node node = this.getCurrentNode();
        if (node.hasAspect(ContentModel.ASPECT_TEMPLATABLE)) {
            NodeRef templateRef = (NodeRef)node.getProperties().get(ContentModel.PROP_TEMPLATE);
            return templateRef != null && this.getNodeService().exists(templateRef) && this.getPermissionService().hasPermission(templateRef, "Read") == AccessStatus.ALLOWED;
        }
        return false;
    }

    public boolean getHasWebscriptView() {
        Node node = this.getCurrentNode();
        if (node.hasAspect(ContentModel.ASPECT_WEBSCRIPTABLE)) {
            return node.getProperties().get(ContentModel.PROP_WEBSCRIPT) != null;
        }
        return false;
    }

    public String getCurrentNodeTemplate() {
        NodeRef ref = (NodeRef)this.getCurrentNode().getProperties().get(ContentModel.PROP_TEMPLATE);
        return ref != null ? ref.toString() : null;
    }

    public String getCurrentNodeWebscript() {
        return (String)this.getCurrentNode().getProperties().get(ContentModel.PROP_WEBSCRIPT);
    }

    public Map getTemplateModel() {
        HashMap<String, Object> model = new HashMap<String, Object>(2, 1.0f);
        model.put("space", this.getCurrentNode().getNodeRef());
        model.put("imageresolver", new TemplateImageResolver(){

            public String resolveImagePathForName(String filename, FileTypeImageSize size) {
                return FileTypeImageUtils.getFileTypeImage((FacesContext)FacesContext.getCurrentInstance(), (String)filename, (FileTypeImageSize)size);
            }
        });
        return model;
    }

    public void resetCurrentNodeProperties() {
        this.currentNode = null;
    }

    public Map<String, Object> getNodeProperties() {
        return this.getCurrentNode().getProperties();
    }

    public Node getCurrentNode() {
        if (this.currentNode == null) {
            Map<String, Object> props;
            Node node;
            if (this.currentNodeId == null) {
                this.processToolbarLocation(this.getToolbarLocation(), false);
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Caching properties for node id: " + this.currentNodeId));
            }
            try {
                NodeRef nodeRef = new NodeRef(Repository.getStoreRef(), this.currentNodeId);
                node = new Node(nodeRef);
                props = node.getProperties();
            }
            catch (InvalidNodeRefException refErr) {
                FacesContext fc = FacesContext.getCurrentInstance();
                Utils.addErrorMessage(MessageFormat.format(Application.getMessage(fc, ERROR_DELETED_FOLDER), this.currentNodeId));
                NodeRef nodeRef = new NodeRef(Repository.getStoreRef(), Application.getCompanyRootId(fc));
                node = new Node(nodeRef);
                props = node.getProperties();
            }
            String icon = (String)props.get("app:icon");
            props.put("icon", icon != null ? icon : "space-icon-default");
            String cifsPath = Utils.generateURL(FacesContext.getCurrentInstance(), node, Utils.URLMode.CIFS);
            node.getProperties().put("cifsPath", cifsPath == null ? "" : cifsPath);
            node.getProperties().put("cifsPathLabel", cifsPath == null ? "" : cifsPath.substring(8));
            this.currentNode = node;
        }
        return this.currentNode;
    }

    public boolean isCreateChildrenPermissionEnabled() {
        return this.getCurrentNode().hasPermission("CreateChildren");
    }

    public List<IBreadcrumbHandler> getLocation() {
        if (this.location == null) {
            this.processToolbarLocation(this.getToolbarLocation(), false);
        }
        return this.location;
    }

    public void setLocation(List<IBreadcrumbHandler> location) {
        this.location = location;
    }

    public boolean getIsGuest() {
        return Repository.getIsGuest(FacesContext.getCurrentInstance());
    }

    public void setupDispatchContext(Node node) {
        this.dispatchContext = node;
    }

    public void resetDispatchContext() {
        this.dispatchContext = null;
    }

    public Node getDispatchContextNode() {
        return this.dispatchContext;
    }

    public Node getCompanyHomeNode() {
        FacesContext fc;
        String companyRootId;
        if (this.companyHomeNode == null && (companyRootId = Application.getCompanyRootId(fc = FacesContext.getCurrentInstance())) != null) {
            NodeRef companyRootRef = new NodeRef(Repository.getStoreRef(), companyRootId);
            this.companyHomeNode = new Node(companyRootRef);
        }
        return this.companyHomeNode;
    }

    public Node getGuestHomeNode() {
        if (this.guestHomeNode == null) {
            try {
                FacesContext fc = FacesContext.getCurrentInstance();
                String xpath = Application.getRootPath(fc) + "/" + Application.getGuestHomeFolderName(fc);
                List guestHomeRefs = this.getSearchService().selectNodes(this.getNodeService().getRootNode(Repository.getStoreRef()), xpath, null, (NamespacePrefixResolver)this.getNamespaceService(), false);
                if (guestHomeRefs.size() == 1) {
                    this.guestHomeNode = new Node((NodeRef)guestHomeRefs.get(0));
                }
            }
            catch (InvalidNodeRefException err1) {
            }
            catch (AccessDeniedException accessDeniedException) {
                // empty catch block
            }
        }
        return this.guestHomeNode;
    }

    public boolean getCompanyHomeVisible() {
        try {
            Node companyHomeNode = this.getCompanyHomeNode();
            if (companyHomeNode != null) {
                return companyHomeNode.hasPermission("Read");
            }
            return false;
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getCompanyHomeVisible failed", e);
            }
            return false;
        }
    }

    public boolean getGuestHomeVisible() {
        try {
            if (this.getAuthService().guestUserAuthenticationAllowed()) {
                Node guestHome = this.getGuestHomeNode();
                return guestHome != null && guestHome.hasPermission("Read");
            }
            return false;
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"getGuestHomeVisible failed", e);
            }
            return false;
        }
    }

    public void toggleShelf(ActionEvent event) {
        this.shelfExpanded = !this.shelfExpanded;
    }

    public void shelfGroupToggled(ActionEvent event) {
        UIShelf.ShelfEvent shelfEvent = (UIShelf.ShelfEvent)event;
        this.shelfItemExpanded[shelfEvent.Index] = shelfEvent.Expanded;
    }

    public void toolbarLocationChanged(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            UIModeList locationList = (UIModeList)event.getComponent();
            String location = locationList.getValue().toString();
            this.processToolbarLocation(location, true);
        }
        catch (InvalidNodeRefException refErr) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_homespace"), Application.getCurrentUser(context).getHomeSpaceId()), refErr);
        }
        catch (Exception err) {
            Utils.addErrorMessage(MessageFormat.format(Application.getMessage(FacesContext.getCurrentInstance(), "error_generic"), err.getMessage()), err);
        }
    }

    public String getCIFSServerPath(DiskSharedDevice diskShare) {
        if (this.cifsServerPath == null) {
            StringBuilder buf = new StringBuilder(32);
            String serverName = this.getServerConfiguration().getServerName();
            if (serverName != null && serverName.length() != 0) {
                buf.append("\\\\");
                buf.append(serverName);
                if (this.clientConfig != null && this.clientConfig.getCifsURLSuffix() != null) {
                    buf.append(this.clientConfig.getCifsURLSuffix());
                }
                buf.append("\\");
                buf.append(diskShare.getName());
            }
            this.cifsServerPath = buf.toString();
        }
        return this.cifsServerPath;
    }

    public boolean isRSSFeed() {
        return SpaceDetailsDialog.hasRSSFeed(this.getCurrentNode());
    }

    public String getRSSFeedURL() {
        return SpaceDetailsDialog.buildRSSFeedURL(this.getCurrentNode());
    }

    public boolean isAllowUserGroupAdmin() {
        return this.clientConfig.isUserGroupAdmin();
    }

    public boolean isAllowUserConfig() {
        return this.clientConfig.getAllowUserConfig();
    }

    public boolean isAllowUserChangePassword() {
        return this.authService.isAuthenticationMutable(this.authService.getCurrentUserName());
    }

    public boolean isTeamMode() {
        Boolean teamMode = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

            public Boolean doWork() throws Exception {
                RepoAdminService s = NavigationBean.this.getRepoAdminService();
                if (s != null && RepoUsage.LicenseMode.TEAM.equals((Object)s.getRestrictions().getLicenseMode())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        return teamMode;
    }

    void initFromClientConfig() {
        this.clientConfig = Application.getClientConfig(FacesContext.getCurrentInstance());
        this.setHelpUrl(this.clientConfig.getHelpUrl());
        this.shelfExpanded = this.clientConfig.isShelfVisible();
    }

    public class NavigationBreadcrumbHandler
    implements IRepoBreadcrumbHandler {
        private static final long serialVersionUID = 4833194653193016638L;
        private String label;
        private NodeRef ref;

        public NavigationBreadcrumbHandler(NodeRef ref, String label) {
            this.label = label;
            this.ref = ref;
        }

        @Override
        public String toString() {
            return this.label;
        }

        @Override
        public String navigationOutcome(UIBreadcrumb breadcrumb) {
            FacesContext fc = FacesContext.getCurrentInstance();
            NavigationBean.this.setCurrentNodeId(this.ref.getId());
            NavigationBean.this.setLocation((List)breadcrumb.getValue());
            NavigationBean.this.setupDispatchContext(new Node(this.ref));
            UIContextService.getInstance(FacesContext.getCurrentInstance()).spaceChanged();
            if (fc.getViewRoot().getViewId().equals("/jsp/browse/browse.jsp")) {
                return null;
            }
            return NavigationBean.OUTCOME_BROWSE;
        }

        @Override
        public NodeRef getNodeRef() {
            return this.ref;
        }
    }
}

